/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectReference;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.openshift.api.model.ImageStreamTag;
import io.dekorate.deps.openshift.api.model.SourceBuildStrategyFluent;
import io.dekorate.deps.openshift.client.OpenShiftClient;
import io.dekorate.kubernetes.decorator.Decorator;
import io.quarkus.container.image.openshift.deployment.OpenshiftConfig;
import io.quarkus.container.image.openshift.deployment.S2iConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenshiftUtils {
    public static boolean waitForImageStreamTags(OpenShiftClient client, Collection<HasMetadata> items, long amount, TimeUnit timeUnit) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        final ArrayList tags = new ArrayList();
        ((KubernetesListBuilder)((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).accept((Visitor)new Decorator<SourceBuildStrategyFluent>(){

            public void visit(SourceBuildStrategyFluent strategy) {
                ObjectReference from = strategy.buildFrom();
                if (from.getKind().equals("ImageStreamTag")) {
                    tags.add(from.getName());
                }
            }
        })).build();
        boolean tagsMissing = true;
        long started = System.currentTimeMillis();
        long elapsed = 0L;
        while (tagsMissing && elapsed < timeUnit.toMillis(amount) && !Thread.interrupted()) {
            tagsMissing = false;
            for (String tag : tags) {
                ImageStreamTag t = (ImageStreamTag)((Resource)client.imageStreamTags().withName(tag)).get();
                if (t != null) continue;
                tagsMissing = true;
            }
            if (!tagsMissing) continue;
            try {
                Thread.sleep(1000L);
                elapsed = System.currentTimeMillis() - started;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return !tagsMissing;
    }

    public static OpenshiftConfig mergeConfig(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig) {
        OpenshiftConfig result;
        OpenshiftConfig openshiftConfig2 = result = openshiftConfig != null ? openshiftConfig : new OpenshiftConfig();
        if (s2iConfig == null) {
            return result;
        }
        Config config = ConfigProvider.getConfig();
        Set properties = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(s -> s.startsWith("quarkus.s2i.") || s.startsWith("quarkus.openshift.")).collect(Collectors.toSet());
        boolean hasS2iBaseJvmImage = properties.contains("quarkus.s2i.base-jvm-image");
        boolean hasS2iBaseNativeImage = properties.contains("quarkus.s2i.base-native-image");
        boolean hasS2iJvmArguments = properties.contains("quarkus.s2i.jvm-arguments");
        boolean hasS2iNativeArguments = properties.contains("quarkus.s2i.native-arguments");
        boolean hasS2iJarDirectory = properties.contains("quarkus.s2i.jar-directory");
        boolean hasS2iJarFileName = properties.contains("quarkus.s2i.jar-file-name");
        boolean hasS2iNativeBinaryDirectory = properties.contains("quarkus.s2i.native-binary-directory");
        boolean hasS2iNativeBinaryFileName = properties.contains("quarkus.s2i.native-binary-file-name");
        boolean hasS2iBuildTimeout = properties.contains("quarkus.s2i.native-binary-file-name");
        boolean hasOpenshiftBaseJvmImage = properties.contains("quarkus.openshift.base-jvm-image");
        boolean hasOpenshiftBaseNativeImage = properties.contains("quarkus.openshift.base-native-image");
        boolean hasOpenshiftJvmArguments = properties.contains("quarkus.openshift.jvm-arguments");
        boolean hasOpenshiftNativeArguments = properties.contains("quarkus.openshift.native-arguments");
        boolean hasOpenshiftJarDirectory = properties.contains("quarkus.openshift.jar-directory");
        boolean hasOpenshiftJarFileName = properties.contains("quarkus.openshift.jar-file-name");
        boolean hasOpenshiftNativeBinaryDirectory = properties.contains("quarkus.openshift.native-binary-directory");
        boolean hasOpenshiftNativeBinaryFileName = properties.contains("quarkus.openshift.native-binary-file-name");
        boolean hasOpenshiftBuildTimeout = properties.contains("quarkus.openshift.native-binary-file-name");
        result.baseJvmImage = hasS2iBaseJvmImage && !hasOpenshiftBaseJvmImage ? s2iConfig.baseJvmImage : openshiftConfig.baseJvmImage;
        result.baseNativeImage = hasS2iBaseNativeImage && !hasOpenshiftBaseNativeImage ? s2iConfig.baseNativeImage : openshiftConfig.baseNativeImage;
        result.jvmArguments = hasS2iJvmArguments && !hasOpenshiftJvmArguments ? s2iConfig.jvmArguments : openshiftConfig.jvmArguments;
        result.nativeArguments = hasS2iNativeArguments && !hasOpenshiftNativeArguments ? s2iConfig.nativeArguments : openshiftConfig.nativeArguments;
        result.jarDirectory = hasS2iJarDirectory && !hasOpenshiftJarDirectory ? Optional.of(s2iConfig.jarDirectory) : openshiftConfig.jarDirectory;
        result.jarFileName = hasS2iJarFileName && !hasOpenshiftJarFileName ? s2iConfig.jarFileName : openshiftConfig.jarFileName;
        result.nativeBinaryDirectory = hasS2iNativeBinaryDirectory && !hasOpenshiftNativeBinaryDirectory ? Optional.of(s2iConfig.nativeBinaryDirectory) : openshiftConfig.nativeBinaryDirectory;
        result.nativeBinaryFileName = hasS2iNativeBinaryFileName && !hasOpenshiftNativeBinaryFileName ? s2iConfig.nativeBinaryFileName : openshiftConfig.nativeBinaryFileName;
        result.buildTimeout = hasS2iBuildTimeout && !hasOpenshiftBuildTimeout ? s2iConfig.buildTimeout : openshiftConfig.buildTimeout;
        result.buildStrategy = openshiftConfig.buildStrategy;
        return result;
    }
}

