/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.dsl.Deletable;
import io.dekorate.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.dekorate.deps.kubernetes.client.dsl.LogWatch;
import io.dekorate.deps.kubernetes.client.dsl.Loggable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.openshift.api.model.Build;
import io.dekorate.deps.openshift.api.model.BuildConfig;
import io.dekorate.deps.openshift.api.model.BuildList;
import io.dekorate.deps.openshift.api.model.ImageStream;
import io.dekorate.deps.openshift.client.OpenShiftClient;
import io.dekorate.deps.openshift.client.dsl.BuildConfigResource;
import io.dekorate.deps.openshift.client.dsl.BuildResource;
import io.dekorate.deps.openshift.client.dsl.InputStreamable;
import io.dekorate.utils.Clients;
import io.dekorate.utils.Packaging;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.image.openshift.deployment.ApplyDockerfileToBuildConfigDecorator;
import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.container.image.openshift.deployment.OpenshiftBaseJavaImage;
import io.quarkus.container.image.openshift.deployment.OpenshiftBaseNativeImage;
import io.quarkus.container.image.openshift.deployment.OpenshiftBuild;
import io.quarkus.container.image.openshift.deployment.OpenshiftConfig;
import io.quarkus.container.image.openshift.deployment.OpenshiftUtils;
import io.quarkus.container.image.openshift.deployment.RemoveEnvVarDecorator;
import io.quarkus.container.image.openshift.deployment.S2iConfig;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHanlder;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class OpenshiftProcessor {
    public static final String OPENSHIFT = "openshift";
    private static final String BUILD_CONFIG_NAME = "openshift.io/build-config.name";
    private static final String RUNNING = "Running";
    private static final Logger LOG = Logger.getLogger(OpenshiftProcessor.class);

    @BuildStep(onlyIf={OpenshiftBuild.class})
    public CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.CONTAINER_IMAGE_OPENSHIFT);
    }

    @BuildStep(onlyIf={OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftPrepareJvmDockerBuild(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, OutputTargetBuildItem out, BuildProducer<DecoratorBuildItem> decorator) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (config.buildStrategy == BuildStrategy.DOCKER) {
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new ApplyDockerfileToBuildConfigDecorator(null, ((Path)PathsUtil.findMainSourcesRoot((Path)out.getOutputDirectory()).getValue()).resolve(openshiftConfig.jvmDockerfile))));
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, "JAVA_APP_JAR")));
        }
    }

    @BuildStep(onlyIf={OpenshiftBuild.class, NativeBuild.class})
    public void openshiftPrepareNativeDockerBuild(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, OutputTargetBuildItem out, BuildProducer<DecoratorBuildItem> decorator) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (config.buildStrategy == BuildStrategy.DOCKER) {
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new ApplyDockerfileToBuildConfigDecorator(null, ((Path)PathsUtil.findMainSourcesRoot((Path)out.getOutputDirectory()).getValue()).resolve(openshiftConfig.nativeDockerfile))));
        }
        decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, "JAVA_APP_JAR")));
    }

    @BuildStep(onlyIf={IsNormal.class, OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftRequirementsJvm(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, JarBuildItem jarBuildItem, BuildProducer<DecoratorBuildItem> decorator, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        String outputJarFileName = jarBuildItem.getPath().getFileName().toString();
        String classpath = appDeps.stream().map(d -> d.getArtifact().getGroupId() + "." + d.getArtifact().getPath().getFileName()).map(s -> OpenshiftProcessor.concatUnixPaths(config.jarDirectory, "lib", s)).collect(Collectors.joining(":"));
        String jarFileName = config.jarFileName.orElse(outputJarFileName);
        String jarDirectory = config.jarDirectory;
        String pathToJar = OpenshiftProcessor.concatUnixPaths(jarDirectory, jarFileName);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-jar", pathToJar, "-cp", classpath));
        args.addAll(config.jvmArguments);
        builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(config.baseJvmImage));
        Optional<OpenshiftBaseJavaImage> baseImage = OpenshiftBaseJavaImage.findMatching(config.baseJvmImage);
        baseImage.ifPresent(b -> {
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJarEnvVar(), (String)pathToJar, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJarLibEnvVar(), (String)OpenshiftProcessor.concatUnixPaths(jarDirectory, "lib"), (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getClasspathEnvVar(), (String)classpath, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJvmOptionsEnvVar(), (String)String.join((CharSequence)" ", config.jvmArguments), (String)OPENSHIFT, (boolean[])new boolean[0]));
        });
        if (!baseImage.isPresent()) {
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)"JAVA_APP_JAR", (String)pathToJar, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)"JAVA_LIB_DIR", (String)OpenshiftProcessor.concatUnixPaths(jarDirectory, "lib"), (String)OPENSHIFT, (boolean[])new boolean[0]));
            commandProducer.produce((BuildItem)new KubernetesCommandBuildItem("java", args.toArray(new String[args.size()])));
        }
    }

    @BuildStep(onlyIf={IsNormal.class, OpenshiftBuild.class, NativeBuild.class})
    public void openshiftRequirementsNative(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, NativeImageBuildItem nativeImage, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        boolean usingDefaultBuilder = ImageUtil.getRepository((String)"quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0").equals(ImageUtil.getRepository((String)config.baseNativeImage));
        String outputNativeBinaryFileName = nativeImage.getPath().getFileName().toString();
        String nativeBinaryFileName = null;
        nativeBinaryFileName = usingDefaultBuilder && !config.nativeBinaryFileName.isPresent() ? "application" : config.nativeBinaryFileName.orElse(outputNativeBinaryFileName);
        String pathToNativeBinary = OpenshiftProcessor.concatUnixPaths(config.nativeBinaryDirectory, nativeBinaryFileName);
        builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(config.baseNativeImage));
        Optional<OpenshiftBaseNativeImage> baseImage = OpenshiftBaseNativeImage.findMatching(config.baseNativeImage);
        baseImage.ifPresent(b -> {
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getHomeDirEnvVar(), (String)config.nativeBinaryDirectory, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getOptsEnvVar(), (String)String.join((CharSequence)" ", config.nativeArguments), (String)OPENSHIFT, (boolean[])new boolean[0]));
        });
        if (!baseImage.isPresent()) {
            commandProducer.produce((BuildItem)new KubernetesCommandBuildItem(pathToNativeBinary, config.nativeArguments.toArray(new String[config.nativeArguments.size()])));
        }
    }

    @BuildStep(onlyIf={IsNormal.class, OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftBuildFromJar(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClient, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, JarBuildItem jar) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith("kubernetes" + File.separator + "openshift.yml")).findFirst();
        if (!openshiftYml.isPresent()) {
            LOG.warn((Object)"No Openshift manifests were generated (most likely due to the fact that the service is not an HTTP service) so no openshift process will be taking place");
            return;
        }
        String namespace = Optional.ofNullable(kubernetesClient.getClient().getNamespace()).orElse("default");
        LOG.info((Object)("Performing openshift binary build with jar on server: " + kubernetesClient.getClient().getMasterUrl() + " in namespace:" + namespace + "."));
        OpenshiftProcessor.createContainerImage(kubernetesClient, openshiftYml.get(), config, "target", out.getOutputDirectory(), jar.getPath(), out.getOutputDirectory().resolve("lib"));
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.emptyMap()));
    }

    @BuildStep(onlyIf={IsNormal.class, OpenshiftBuild.class, NativeBuild.class})
    public void openshiftBuildFromNative(OpenshiftConfig openshiftConfig, S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClient, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, NativeImageBuildItem nativeImage) {
        OpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        String namespace = Optional.ofNullable(kubernetesClient.getClient().getNamespace()).orElse("default");
        LOG.info((Object)("Performing openshift binary build with native image on server: " + kubernetesClient.getClient().getMasterUrl() + " in namespace:" + namespace + "."));
        Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith("kubernetes" + File.separator + "openshift.yml")).findFirst();
        if (!openshiftYml.isPresent()) {
            LOG.warn((Object)"No Openshift manifests were generated (most likely due to the fact that the service is not an HTTP service) so no openshift process will be taking place");
            return;
        }
        OpenshiftProcessor.createContainerImage(kubernetesClient, openshiftYml.get(), config, null, out.getOutputDirectory(), nativeImage.getPath());
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.emptyMap()));
    }

    public static void createContainerImage(KubernetesClientBuildItem kubernetesClient, GeneratedFileSystemResourceBuildItem openshiftManifests, OpenshiftConfig openshiftConfig, String base, Path output, Path ... additional) {
        File tar;
        try {
            File original = Packaging.packageFile((Path)output, (String)base, (Path[])additional);
            tar = Files.createTempFile("quarkus-", "-openshift", new FileAttribute[0]).toFile();
            Files.move(original.toPath(), tar.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating the openshift binary build archive.", e);
        }
        Config config = kubernetesClient.getClient().getConfiguration();
        config.setHttp2Disable(true);
        try (KubernetesClient client = Clients.fromConfig((Object)config);){
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            KubernetesList kubernetesList = Serialization.unmarshalAsList((InputStream)new ByteArrayInputStream(openshiftManifests.getData()));
            List<HasMetadata> buildResources = kubernetesList.getItems().stream().filter(i -> i instanceof BuildConfig || i instanceof ImageStream || i instanceof Secret).collect(Collectors.toList());
            OpenshiftProcessor.applyOpenshiftResources(openShiftClient, buildResources);
            OpenshiftProcessor.openshiftBuild(openShiftClient, buildResources, tar, openshiftConfig);
        }
    }

    private static void applyOpenshiftResources(OpenShiftClient client, List<HasMetadata> buildResources) {
        try {
            for (HasMetadata i : OpenshiftProcessor.distinct(buildResources)) {
                if (i instanceof BuildConfig) {
                    ((Deletable)client.resource(i).cascading(true)).delete();
                    try {
                        client.resource(i).waitUntilCondition(d -> d == null, 10L, TimeUnit.SECONDS);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InterruptedException e) {
                        OpenshiftProcessor.openshiftException(e);
                    }
                } else if (i instanceof ImageStream) {
                    ImageStream is = (ImageStream)i;
                    ImageStream existing = (ImageStream)((Resource)client.imageStreams().withName(i.getMetadata().getName())).get();
                    if (existing != null && existing.getSpec() != null && existing.getSpec().getDockerImageRepository() != null && existing.getSpec().getDockerImageRepository().equals(is.getSpec().getDockerImageRepository())) {
                        LOG.info((Object)("Found: " + i.getKind() + " " + i.getMetadata().getName() + " repository: " + existing.getSpec().getDockerImageRepository()));
                        continue;
                    }
                }
                client.resource(i).createOrReplace();
                LOG.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName()));
            }
            OpenshiftUtils.waitForImageStreamTags(client, buildResources, 2L, TimeUnit.MINUTES);
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHanlder.handle((Exception)((Object)e));
        }
    }

    private static void openshiftBuild(OpenShiftClient client, List<HasMetadata> buildResources, File binaryFile, OpenshiftConfig openshiftConfig) {
        OpenshiftProcessor.distinct(buildResources).stream().filter(i -> i instanceof BuildConfig).map(i -> (BuildConfig)i).forEach(bc -> OpenshiftProcessor.openshiftBuild(client, bc, binaryFile, openshiftConfig));
    }

    private static void openshiftBuild(OpenShiftClient client, BuildConfig buildConfig, File binaryFile, OpenshiftConfig openshiftConfig) {
        Build build;
        try {
            build = (Build)((InputStreamable)((BuildConfigResource)client.buildConfigs().withName(buildConfig.getMetadata().getName())).instantiateBinary().withTimeoutInMillis(openshiftConfig.buildTimeout.toMillis())).fromFile(binaryFile);
        }
        catch (Exception e) {
            Optional<Build> running = OpenshiftProcessor.runningBuildsOf(client, buildConfig).findFirst();
            if (running.isPresent()) {
                LOG.warn((Object)("An exception: '" + e.getMessage() + " ' occurred while instantiating the build, however the build has been started."));
                build = running.get();
            }
            throw OpenshiftProcessor.openshiftException(e);
        }
        String buildName = build.getMetadata().getName();
        try (LogWatch w = (LogWatch)((Loggable)((BuildResource)client.builds().withName(build.getMetadata().getName())).withPrettyOutput()).watchLog();
             BufferedReader reader = new BufferedReader(new InputStreamReader(w.getOutput()));){
            OpenshiftProcessor.waitForBuildComplete(client, openshiftConfig, buildName, (Closeable)w);
            String line = reader.readLine();
            while (line != null) {
                LOG.info((Object)line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw OpenshiftProcessor.openshiftException(e);
        }
    }

    private static void waitForBuildComplete(OpenShiftClient client, OpenshiftConfig openshiftConfig, String buildName, Closeable watch) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            try {
                ((BuildResource)client.builds().withName(buildName)).waitUntilCondition(b -> !RUNNING.equalsIgnoreCase(b.getStatus().getPhase()), openshiftConfig.buildTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                OpenshiftProcessor.openshiftException(e);
            }
            finally {
                try {
                    watch.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)"Error closing log reader.");
                }
            }
        });
    }

    public static Predicate<HasMetadata> distictByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }

    private static Collection<HasMetadata> distinct(Collection<HasMetadata> resources) {
        return resources.stream().filter(OpenshiftProcessor.distictByResourceKey()).collect(Collectors.toList());
    }

    private static List<Build> buildsOf(OpenShiftClient client, BuildConfig config) {
        return ((BuildList)((FilterWatchListDeletable)client.builds().withLabel(BUILD_CONFIG_NAME, config.getMetadata().getName())).list()).getItems();
    }

    private static Stream<Build> runningBuildsOf(OpenShiftClient client, BuildConfig config) {
        return OpenshiftProcessor.buildsOf(client, config).stream().filter(b -> RUNNING.equalsIgnoreCase(b.getStatus().getPhase()));
    }

    private static RuntimeException openshiftException(Throwable t) {
        if (t instanceof KubernetesClientException) {
            KubernetesClientErrorHanlder.handle((Exception)((Object)((KubernetesClientException)t)));
        }
        return new RuntimeException("Execution of openshift build failed. See build output for more details", t);
    }

    static String concatUnixPaths(String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String element : elements) {
            if (element.endsWith("/")) {
                element = element.substring(0, element.length() - 1);
            }
            if (element.isEmpty()) continue;
            if (!element.startsWith("/") && result.length() > 0) {
                result.append('/');
            }
            result.append(element);
        }
        return result.toString();
    }
}

