/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.deployment.util.ImageUtil;
import java.util.Optional;

public enum OpenshiftBaseNativeImage {
    QUARKUS("quarkus/ubi-quarkus-native-binary-s2i:2.0", "/home/quarkus/", "application", "QUARKUS_HOME", "QUARKUS_OPTS");

    private final String image;
    private final String nativeBinaryDirectory;
    private final String fixedNativeBinaryName;
    private final String homeDirEnvVar;
    private final String optsEnvVar;

    public static Optional<OpenshiftBaseNativeImage> findMatching(String image) {
        for (OpenshiftBaseNativeImage candidate : OpenshiftBaseNativeImage.values()) {
            if (!ImageUtil.getRepository((String)candidate.getImage()).equals(ImageUtil.getRepository((String)image))) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    private OpenshiftBaseNativeImage(String image, String nativeBinaryDirectory, String fixedNativeBinaryName, String homeDirEnvVar, String optsEnvVar) {
        this.image = image;
        this.nativeBinaryDirectory = nativeBinaryDirectory;
        this.fixedNativeBinaryName = fixedNativeBinaryName;
        this.homeDirEnvVar = homeDirEnvVar;
        this.optsEnvVar = optsEnvVar;
    }

    public String getImage() {
        return this.image;
    }

    public String getNativeBinaryDirectory() {
        return this.nativeBinaryDirectory;
    }

    public String getFixedNativeBinaryName() {
        return this.fixedNativeBinaryName;
    }

    public String getHomeDirEnvVar() {
        return this.homeDirEnvVar;
    }

    public String getOptsEnvVar() {
        return this.optsEnvVar;
    }
}

