/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.deployment.util.ImageUtil;
import java.util.Optional;

public enum S2iBaseJavaImage {
    FABRIC8("fabric8/s2i-java:latest", "JAVA_MAIN_CLASS", "JAVA_APP_JAR", "JAVA_LIB_DIR", "JAVA_CLASSPATH", "JAVA_OPTIONS");

    private final String image;
    private final String javaMainClassEnvVar;
    private final String jarEnvVar;
    private final String jarLibEnvVar;
    private final String classpathEnvVar;
    private final String jvmOptionsEnvVar;

    public static Optional<S2iBaseJavaImage> findMatching(String image) {
        for (S2iBaseJavaImage candidate : S2iBaseJavaImage.values()) {
            if (!ImageUtil.getRepository((String)candidate.getImage()).equals(ImageUtil.getRepository((String)image))) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    private S2iBaseJavaImage(String image, String javaMainClassEnvVar, String jarEnvVar, String jarLibEnvVar, String classpathEnvVar, String jvmOptionsEnvVar) {
        this.image = image;
        this.javaMainClassEnvVar = javaMainClassEnvVar;
        this.jarEnvVar = jarEnvVar;
        this.jarLibEnvVar = jarLibEnvVar;
        this.classpathEnvVar = classpathEnvVar;
        this.jvmOptionsEnvVar = jvmOptionsEnvVar;
    }

    public String getImage() {
        return this.image;
    }

    public String getJavaMainClassEnvVar() {
        return this.javaMainClassEnvVar;
    }

    public String getJvmOptionsEnvVar() {
        return this.jvmOptionsEnvVar;
    }

    public String getClasspathEnvVar() {
        return this.classpathEnvVar;
    }

    public String getJarLibEnvVar() {
        return this.jarLibEnvVar;
    }

    public String getJarEnvVar() {
        return this.jarEnvVar;
    }
}

