/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

@ConfigRoot(name="openshift", phase=ConfigPhase.BUILD_TIME)
public class ContainerImageOpenshiftConfig {
    public static final String DEFAULT_BASE_JVM_JDK17_IMAGE = "registry.access.redhat.com/ubi8/openjdk-17:1.18";
    public static final String DEFAULT_BASE_JVM_JDK21_IMAGE = "registry.access.redhat.com/ubi8/openjdk-21:1.18";
    public static final String DEFAULT_BASE_NATIVE_IMAGE = "quay.io/quarkus/ubi-quarkus-native-binary-s2i:2.0";
    public static final String DEFAULT_NATIVE_TARGET_FILENAME = "application";
    public static final String DEFAULT_JVM_DOCKERFILE = "src/main/docker/Dockerfile.jvm";
    public static final String DEFAULT_NATIVE_DOCKERFILE = "src/main/docker/Dockerfile.native";
    public static final String DEFAULT_BUILD_LOG_LEVEL = "INFO";
    public static final String FALLBACK_JAR_DIRECTORY = "/deployments/";
    public static final String FALLBACK_NATIVE_BINARY_DIRECTORY = "/home/quarkus/";
    @ConfigItem(defaultValue="binary")
    public BuildStrategy buildStrategy;
    @ConfigItem
    public Optional<String> baseJvmImage;
    @ConfigItem(defaultValue="quay.io/quarkus/ubi-quarkus-native-binary-s2i:2.0")
    public String baseNativeImage;
    @ConfigItem(defaultValue="src/main/docker/Dockerfile.jvm")
    public String jvmDockerfile;
    @ConfigItem(defaultValue="src/main/docker/Dockerfile.native")
    public String nativeDockerfile;
    @ConfigItem
    public Optional<List<String>> jvmArguments;
    @ConfigItem
    public Optional<List<String>> nativeArguments;
    @ConfigItem
    public Optional<String> jarDirectory;
    @ConfigItem
    public Optional<String> jarFileName;
    @ConfigItem
    public Optional<String> nativeBinaryDirectory;
    @ConfigItem
    public Optional<String> nativeBinaryFileName;
    @ConfigItem(defaultValue="PT5M")
    Duration buildTimeout;
    @ConfigItem(defaultValue="INFO")
    public Logger.Level buildLogLevel;
    @ConfigItem
    public Optional<String> imagePushSecret;

    public static String getDefaultJvmImage(CompiledJavaVersionBuildItem.JavaVersion version) {
        if (version.isJava21OrHigher() == CompiledJavaVersionBuildItem.JavaVersion.Status.TRUE) {
            return DEFAULT_BASE_JVM_JDK21_IMAGE;
        }
        return DEFAULT_BASE_JVM_JDK17_IMAGE;
    }

    public boolean hasDefaultBaseJvmImage() {
        return this.baseJvmImage.isPresent();
    }

    public boolean hasDefaultBaseNativeImage() {
        return this.baseNativeImage.equals(DEFAULT_BASE_NATIVE_IMAGE);
    }

    public boolean hasDefaultJvmDockerfile() {
        return this.jvmDockerfile.equals(DEFAULT_JVM_DOCKERFILE);
    }

    public boolean hasDefaultNativeDockerfile() {
        return this.nativeDockerfile.equals(DEFAULT_NATIVE_DOCKERFILE);
    }

    public List<String> getEffectiveJvmArguments() {
        ArrayList<String> effectiveJvmArguments = new ArrayList<String>();
        this.jvmArguments.ifPresent(effectiveJvmArguments::addAll);
        return effectiveJvmArguments;
    }
}

