/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.dekorate.kubernetes.decorator.AddDockerConfigJsonSecretDecorator;
import io.dekorate.utils.Packaging;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.image.openshift.deployment.ApplyDockerImageOutputToBuildConfigDecorator;
import io.quarkus.container.image.openshift.deployment.ApplyDockerImageRepositoryToImageStream;
import io.quarkus.container.image.openshift.deployment.ApplyDockerfileToBuildConfigDecorator;
import io.quarkus.container.image.openshift.deployment.BuildStatus;
import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.container.image.openshift.deployment.ContainerImageOpenshiftConfig;
import io.quarkus.container.image.openshift.deployment.OpenshiftBuild;
import io.quarkus.container.image.openshift.deployment.OpenshiftUtils;
import io.quarkus.container.image.openshift.deployment.RemoveEnvVarDecorator;
import io.quarkus.container.image.openshift.deployment.S2iConfig;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHandler;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.DeployStrategy;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class OpenshiftProcessor {
    public static final String OPENSHIFT = "openshift";
    private static final String BUILD_CONFIG_NAME = "openshift.io/build-config.name";
    private static final String RUNNING = "Running";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private static final String OPENSHIFT_INTERNAL_REGISTRY = "openshift-image-registry";
    private static final int LOG_TAIL_SIZE = 10;
    private static final Logger LOG = Logger.getLogger(OpenshiftProcessor.class);

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(OPENSHIFT);
    }

    @BuildStep(onlyIf={OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftPrepareJvmDockerBuild(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, OutputTargetBuildItem out, BuildProducer<DecoratorBuildItem> decorator) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (config.buildStrategy == BuildStrategy.DOCKER) {
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new ApplyDockerfileToBuildConfigDecorator(null, ((Path)PathsUtil.findMainSourcesRoot((Path)out.getOutputDirectory()).getValue()).resolve(openshiftConfig.jvmDockerfile))));
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, JAVA_APP_JAR)));
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, "JAVA_APP_LIB")));
        }
    }

    @BuildStep(onlyIf={OpenshiftBuild.class, NativeBuild.class})
    public void openshiftPrepareNativeDockerBuild(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, OutputTargetBuildItem out, BuildProducer<DecoratorBuildItem> decorator) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (config.buildStrategy == BuildStrategy.DOCKER) {
            decorator.produce((BuildItem)new DecoratorBuildItem((Object)new ApplyDockerfileToBuildConfigDecorator(null, ((Path)PathsUtil.findMainSourcesRoot((Path)out.getOutputDirectory()).getValue()).resolve(openshiftConfig.nativeDockerfile))));
        }
        decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, JAVA_APP_JAR)));
        decorator.produce((BuildItem)new DecoratorBuildItem((Object)new RemoveEnvVarDecorator(null, "JAVA_APP_LIB")));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftRequirementsJvm(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, JarBuildItem jarBuildItem, CompiledJavaVersionBuildItem compiledJavaVersion, BuildProducer<DecoratorBuildItem> decorator, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        String outputJarFileName = jarBuildItem.getPath().getFileName().toString();
        String jarFileName = config.jarFileName.orElse(outputJarFileName);
        String baseJvmImage = config.baseJvmImage.orElse(ContainerImageOpenshiftConfig.getDefaultJvmImage(compiledJavaVersion.getJavaVersion()));
        boolean hasCustomJarPath = config.jarFileName.isPresent() || config.jarDirectory.isPresent();
        boolean hasCustomJvmArguments = config.jvmArguments.isPresent();
        builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(baseJvmImage));
        if (config.buildStrategy == BuildStrategy.BINARY) {
            String jarDirectory = config.jarDirectory.orElse("/deployments/");
            String pathToJar = OpenshiftProcessor.concatUnixPaths(jarDirectory, jarFileName);
            if (hasCustomJarPath || hasCustomJvmArguments) {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("java");
                cmd.addAll(config.getEffectiveJvmArguments());
                cmd.addAll(Arrays.asList("-jar", pathToJar));
                envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)JAVA_APP_JAR, (String)pathToJar, null, (boolean[])new boolean[0]));
                commandProducer.produce((BuildItem)KubernetesCommandBuildItem.command(cmd));
            }
        }
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, OpenshiftBuild.class, NativeBuild.class})
    public void openshiftRequirementsNative(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, NativeImageBuildItem nativeImage, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        boolean usingDefaultBuilder = ImageUtil.getRepository((String)"quay.io/quarkus/ubi-quarkus-native-binary-s2i:2.0").equals(ImageUtil.getRepository((String)config.baseNativeImage));
        String outputNativeBinaryFileName = nativeImage.getPath().getFileName().toString();
        String nativeBinaryFileName = null;
        boolean hasCustomNativePath = config.nativeBinaryFileName.isPresent() || config.nativeBinaryDirectory.isPresent();
        boolean hasCustomNativeArguments = config.nativeArguments.isPresent();
        nativeBinaryFileName = usingDefaultBuilder && !config.nativeBinaryFileName.isPresent() ? "application" : config.nativeBinaryFileName.orElse(outputNativeBinaryFileName);
        if (config.buildStrategy == BuildStrategy.BINARY) {
            builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(config.baseNativeImage));
            String nativeBinaryDirectory = config.nativeBinaryDirectory.orElse("/home/quarkus/");
            String pathToNativeBinary = OpenshiftProcessor.concatUnixPaths(nativeBinaryDirectory, nativeBinaryFileName);
            if (hasCustomNativePath || hasCustomNativeArguments) {
                commandProducer.produce((BuildItem)KubernetesCommandBuildItem.commandWithArgs((String)pathToNativeBinary, config.nativeArguments.get()));
            }
        }
    }

    @BuildStep(onlyIf={OpenshiftBuild.class})
    public void configureExternalRegistry(ApplicationInfoBuildItem applicationInfo, ContainerImageOpenshiftConfig openshiftConfig, ContainerImageInfoBuildItem containerImageInfo, BuildProducer<DecoratorBuildItem> decorator) {
        containerImageInfo.registry.ifPresent(registry -> {
            String name = applicationInfo.getName();
            String serviceAccountName = applicationInfo.getName();
            String repositoryWithRegistry = registry + "/" + containerImageInfo.getRepository();
            if (openshiftConfig.imagePushSecret.isPresent()) {
                String imagePushSecret = openshiftConfig.imagePushSecret.get();
                decorator.produce((BuildItem)new DecoratorBuildItem(OPENSHIFT, (Object)new ApplyDockerImageOutputToBuildConfigDecorator(applicationInfo.getName(), containerImageInfo.getImage(), imagePushSecret)));
            } else if (!registry.contains(OPENSHIFT_INTERNAL_REGISTRY)) {
                if (containerImageInfo.username.isPresent() && containerImageInfo.password.isPresent()) {
                    String imagePushSecret = applicationInfo.getName() + "-push-secret";
                    decorator.produce((BuildItem)new DecoratorBuildItem(OPENSHIFT, (Object)new AddDockerConfigJsonSecretDecorator(imagePushSecret, (String)containerImageInfo.registry.get(), (String)containerImageInfo.username.get(), (String)containerImageInfo.password.get())));
                    decorator.produce((BuildItem)new DecoratorBuildItem(OPENSHIFT, (Object)new ApplyDockerImageOutputToBuildConfigDecorator(applicationInfo.getName(), containerImageInfo.getImage(), imagePushSecret)));
                } else {
                    LOG.warn((Object)"An external image registry has been specified, but no push secret or credentials.");
                }
            }
            decorator.produce((BuildItem)new DecoratorBuildItem(OPENSHIFT, (Object)new ApplyDockerImageRepositoryToImageStream(applicationInfo.getName(), repositoryWithRegistry)));
        });
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, OpenshiftBuild.class}, onlyIfNot={NativeBuild.class})
    public void openshiftBuildFromJar(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClientBuilder, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, JarBuildItem jar) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!(containerImageConfig.isBuildExplicitlyEnabled() || containerImageConfig.isPushExplicitlyEnabled() || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith(File.separator + "openshift.yml")).findFirst();
        if (openshiftYml.isEmpty()) {
            LOG.warn((Object)"No Openshift manifests were generated so no openshift build process will be taking place");
            return;
        }
        try (KubernetesClient kubernetesClient = OpenshiftProcessor.buildClient(kubernetesClientBuilder);){
            String namespace = Optional.ofNullable(kubernetesClient.getNamespace()).orElse("default");
            LOG.info((Object)("Starting (in-cluster) container image build for jar using: " + config.buildStrategy + " on server: " + kubernetesClient.getMasterUrl() + " in namespace:" + namespace + "."));
            String outputDirName = out.getOutputDirectory().getFileName().toString();
            String contextRoot = this.getContextRoot(outputDirName, packageConfig.isFastJar(), config.buildStrategy);
            KubernetesClientBuilder clientBuilder = OpenshiftProcessor.newClientBuilderWithoutHttp2(kubernetesClient.getConfiguration(), kubernetesClientBuilder.getHttpClientFactory());
            if (packageConfig.isFastJar()) {
                OpenshiftProcessor.createContainerImage(clientBuilder, openshiftYml.get(), config, contextRoot, jar.getPath().getParent(), jar.getPath().getParent());
            } else if (jar.getLibraryDir() != null) {
                OpenshiftProcessor.createContainerImage(clientBuilder, openshiftYml.get(), config, contextRoot, jar.getPath().getParent(), jar.getPath(), jar.getLibraryDir());
            } else {
                OpenshiftProcessor.createContainerImage(clientBuilder, openshiftYml.get(), config, contextRoot, jar.getPath().getParent(), jar.getPath());
            }
            artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.emptyMap()));
            containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(OPENSHIFT));
        }
    }

    private String getContextRoot(String outputDirName, boolean isFastJar, BuildStrategy buildStrategy) {
        if (buildStrategy != BuildStrategy.DOCKER) {
            return null;
        }
        if (!isFastJar) {
            return outputDirName;
        }
        return outputDirName + "/quarkus-app";
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, OpenshiftBuild.class, NativeBuild.class})
    public void openshiftBuildFromNative(ContainerImageOpenshiftConfig openshiftConfig, S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClientBuilder, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, NativeImageBuildItem nativeImage) {
        ContainerImageOpenshiftConfig config = OpenshiftUtils.mergeConfig(openshiftConfig, s2iConfig);
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!(containerImageConfig.isBuildExplicitlyEnabled() || containerImageConfig.isPushExplicitlyEnabled() || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        try (KubernetesClient kubernetesClient = OpenshiftProcessor.buildClient(kubernetesClientBuilder);){
            String namespace = Optional.ofNullable(kubernetesClient.getNamespace()).orElse("default");
            LOG.info((Object)("Starting (in-cluster) container image build for jar using: " + config.buildStrategy + " on server: " + kubernetesClient.getMasterUrl() + " in namespace:" + namespace + "."));
            Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith(File.separator + "openshift.yml")).findFirst();
            if (openshiftYml.isEmpty()) {
                LOG.warn((Object)"No Openshift manifests were generated so no openshift build process will be taking place");
                return;
            }
            String contextRoot = config.buildStrategy == BuildStrategy.DOCKER ? "target" : null;
            OpenshiftProcessor.createContainerImage(OpenshiftProcessor.newClientBuilderWithoutHttp2(kubernetesClient.getConfiguration(), kubernetesClientBuilder.getHttpClientFactory()), openshiftYml.get(), config, contextRoot, out.getOutputDirectory(), nativeImage.getPath());
            artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.emptyMap()));
            containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(OPENSHIFT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContainerImage(KubernetesClientBuilder kubernetesClientBuilder, GeneratedFileSystemResourceBuildItem openshiftManifests, ContainerImageOpenshiftConfig openshiftConfig, String base, Path output, Path ... additional) {
        File tar;
        try {
            File original = Packaging.packageFile((Path)output, (String)base, (Path[])additional);
            tar = Files.createTempFile("quarkus-", "-openshift", new FileAttribute[0]).toFile();
            Files.move(original.toPath(), tar.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating the openshift binary build archive.", e);
        }
        try (KubernetesClient client = kubernetesClientBuilder.build();){
            OpenShiftClient openShiftClient = OpenshiftProcessor.toOpenshiftClient(client);
            KubernetesList kubernetesList = Serialization.unmarshalAsList((InputStream)new ByteArrayInputStream(openshiftManifests.getData()));
            List<HasMetadata> buildResources = kubernetesList.getItems().stream().filter(i -> i instanceof BuildConfig || i instanceof ImageStream || i instanceof Secret).collect(Collectors.toList());
            OpenshiftProcessor.applyOpenshiftResources(openShiftClient, buildResources);
            OpenshiftProcessor.openshiftBuild(buildResources, tar, openshiftConfig, kubernetesClientBuilder);
        }
        finally {
            try {
                tar.delete();
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to delete temporary file " + tar.toPath().toAbsolutePath()), (Throwable)e);
            }
        }
    }

    private static OpenShiftClient toOpenshiftClient(KubernetesClient client) {
        try {
            return (OpenShiftClient)client.adapt(OpenShiftClient.class);
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHandler.handle((Exception)((Object)e));
            return null;
        }
    }

    private static void applyOpenshiftResources(OpenShiftClient client, List<HasMetadata> buildResources) {
        try {
            for (HasMetadata i : OpenshiftProcessor.distinct(buildResources)) {
                OpenshiftProcessor.deployResource(client, i);
                LOG.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName()));
            }
            try {
                OpenshiftUtils.waitForImageStreamTags(client, buildResources, 2L, TimeUnit.MINUTES);
            }
            catch (KubernetesClientException e) {
                LOG.debug((Object)"Waiting for ImageStream tag failed. Ignoring.");
            }
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHandler.handle((Exception)((Object)e));
        }
    }

    private static void openshiftBuild(List<HasMetadata> buildResources, File binaryFile, ContainerImageOpenshiftConfig openshiftConfig, KubernetesClientBuilder kubernetesClientBuilder) {
        OpenshiftProcessor.distinct(buildResources).stream().filter(i -> i instanceof BuildConfig).map(i -> (BuildConfig)i).forEach(bc -> {
            Build build = OpenshiftProcessor.startOpenshiftBuild(bc, binaryFile, openshiftConfig, kubernetesClientBuilder);
            OpenshiftProcessor.waitForOpenshiftBuild(build, openshiftConfig, kubernetesClientBuilder);
        });
    }

    private static Build startOpenshiftBuild(BuildConfig buildConfig, File binaryFile, ContainerImageOpenshiftConfig openshiftConfig, KubernetesClientBuilder kubernetesClientBuilder) {
        try (KubernetesClient kubernetesClient = kubernetesClientBuilder.build();){
            OpenShiftClient client = OpenshiftProcessor.toOpenshiftClient(kubernetesClient);
            try {
                Build build = (Build)((BuildConfigResource)client.buildConfigs().withName(buildConfig.getMetadata().getName())).instantiateBinary().withTimeoutInMillis(openshiftConfig.buildTimeout.toMillis()).fromFile(binaryFile);
                return build;
            }
            catch (Exception e) {
                block10: {
                    Build build;
                    block11: {
                        Optional running = OpenshiftProcessor.buildsOf(client, buildConfig).stream().findFirst();
                        if (!running.isPresent()) break block10;
                        LOG.warn((Object)("An exception: '" + e.getMessage() + " ' occurred while instantiating the build, however the build has been started."));
                        build = (Build)running.get();
                        if (kubernetesClient == null) break block11;
                        kubernetesClient.close();
                    }
                    return build;
                }
                throw OpenshiftProcessor.openshiftException(e);
            }
        }
    }

    private static void waitForOpenshiftBuild(Build build, ContainerImageOpenshiftConfig openshiftConfig, KubernetesClientBuilder kubernetesClientBuilder) {
        while (OpenshiftProcessor.isNew(build) || OpenshiftProcessor.isPending(build) || OpenshiftProcessor.isRunning(build)) {
            String buildName = build.getMetadata().getName();
            KubernetesClient kubernetesClient = kubernetesClientBuilder.build();
            try {
                OpenShiftClient client = OpenshiftProcessor.toOpenshiftClient(kubernetesClient);
                Build updated = (Build)((BuildResource)client.builds().withName(buildName)).get();
                if (updated == null) {
                    throw new IllegalStateException("Build:" + build.getMetadata().getName() + " is no longer present!");
                }
                if (updated.getStatus() == null) {
                    throw new IllegalStateException("Build:" + build.getMetadata().getName() + " has no status!");
                }
                if (OpenshiftProcessor.isNew(updated) || OpenshiftProcessor.isPending(updated) || OpenshiftProcessor.isRunning(updated)) {
                    build = updated;
                    try (LogWatch w = ((BuildResource)client.builds().withName(buildName)).withPrettyOutput().watchLog();
                         InputStreamReader reader = new InputStreamReader(w.getOutput());){
                        OpenshiftProcessor.display(reader, openshiftConfig.buildLogLevel);
                    }
                    catch (KubernetesClientException | IOException ex) {
                        LOG.warn((Object)"Log stream closed, redisplaying last 10 entries:");
                        try {
                            OpenshiftProcessor.display(((BuildResource)client.builds().withName(buildName)).tailingLines(10).getLogReader(), Logger.Level.WARN);
                        }
                        catch (KubernetesClientException | IOException throwable) {}
                    }
                    continue;
                }
                if (OpenshiftProcessor.isComplete(updated)) {
                    return;
                }
                if (OpenshiftProcessor.isCancelled(updated)) {
                    throw new IllegalStateException("Build:" + buildName + " cancelled!");
                }
                if (OpenshiftProcessor.isFailed(updated)) {
                    throw new IllegalStateException("Build:" + buildName + " failed! " + updated.getStatus().getMessage());
                }
                if (!OpenshiftProcessor.isError(updated)) continue;
                throw new IllegalStateException("Build:" + buildName + " encountered error! " + updated.getStatus().getMessage());
            }
            finally {
                if (kubernetesClient == null) continue;
                kubernetesClient.close();
            }
        }
    }

    public static Predicate<HasMetadata> distinctByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }

    private static Collection<HasMetadata> distinct(Collection<HasMetadata> resources) {
        return resources.stream().filter(OpenshiftProcessor.distinctByResourceKey()).collect(Collectors.toList());
    }

    private static List<Build> buildsOf(OpenShiftClient client, BuildConfig config) {
        return ((BuildList)((FilterWatchListDeletable)client.builds().withLabel(BUILD_CONFIG_NAME, config.getMetadata().getName())).list()).getItems();
    }

    private static RuntimeException openshiftException(Throwable t) {
        if (t instanceof KubernetesClientException) {
            KubernetesClientErrorHandler.handle((Exception)((Object)((KubernetesClientException)t)));
        }
        return new RuntimeException("Execution of openshift build failed. See build output for more details", t);
    }

    private static void display(Reader logReader, Logger.Level level) throws IOException {
        BufferedReader reader = new BufferedReader(logReader);
        String line = reader.readLine();
        while (line != null) {
            LOG.log(level, (Object)line);
            line = reader.readLine();
        }
    }

    private static KubernetesClientBuilder newClientBuilderWithoutHttp2(Config configuration, HttpClient.Factory httpClientFactory) {
        configuration.setHttp2Disable(true);
        return new KubernetesClientBuilder().withConfig(configuration).withHttpClientFactory(httpClientFactory);
    }

    private static KubernetesClient buildClient(KubernetesClientBuildItem kubernetesClientBuilder) {
        OpenshiftUtils.getNamespace().ifPresent(arg_0 -> ((Config)kubernetesClientBuilder.getConfig()).setNamespace(arg_0));
        return kubernetesClientBuilder.buildClient();
    }

    private static void deployResource(OpenShiftClient client, HasMetadata metadata) {
        DeployStrategy deployStrategy = OpenshiftUtils.getDeployStrategy();
        NamespaceableResource r = client.resource(metadata);
        if (deployStrategy != DeployStrategy.CreateOrUpdate && r instanceof BuildConfig) {
            OpenshiftProcessor.deleteBuildConfig(client, metadata, (NamespaceableResource<HasMetadata>)r);
        }
        if (r instanceof ImageStream) {
            ImageStream is = (ImageStream)r;
            ImageStream existing = (ImageStream)((Resource)client.imageStreams().withName(metadata.getMetadata().getName())).get();
            if (existing != null && existing.getSpec() != null && existing.getSpec().getDockerImageRepository() != null && existing.getSpec().getDockerImageRepository().equals(is.getSpec().getDockerImageRepository())) {
                LOG.info((Object)("Found: " + metadata.getKind() + " " + metadata.getMetadata().getName() + " repository: " + existing.getSpec().getDockerImageRepository()));
                return;
            }
        }
        switch (deployStrategy) {
            case Create: {
                r.create();
                break;
            }
            case Replace: {
                r.replace();
                break;
            }
            case ServerSideApply: {
                r.patch(PatchContext.of((PatchType)PatchType.SERVER_SIDE_APPLY));
                break;
            }
            default: {
                r.createOrReplace();
            }
        }
    }

    private static void deleteBuildConfig(OpenShiftClient client, HasMetadata metadata, NamespaceableResource<HasMetadata> r) {
        r.cascading(true).delete();
        try {
            client.resource(metadata).waitUntilCondition(d -> d == null, 10L, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static String concatUnixPaths(String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String element : elements) {
            if (element.endsWith("/")) {
                element = element.substring(0, element.length() - 1);
            }
            if (element.isEmpty()) continue;
            if (!element.startsWith("/") && result.length() > 0) {
                result.append('/');
            }
            result.append(element);
        }
        return result.toString();
    }

    static boolean isNew(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.New.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isPending(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Pending.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isRunning(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Running.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isComplete(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Complete.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isFailed(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Failed.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isError(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Error.name().equalsIgnoreCase(build.getStatus().getPhase());
    }

    static boolean isCancelled(Build build) {
        return build != null && build.getStatus() != null && BuildStatus.Cancelled.name().equalsIgnoreCase(build.getStatus().getPhase());
    }
}

