/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.podman.deployment;

import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.docker.common.deployment.CommonProcessor;
import io.quarkus.container.image.podman.deployment.PodmanBuild;
import io.quarkus.container.image.podman.deployment.PodmanConfig;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ContainerRuntimeStatusBuildItem;
import io.quarkus.deployment.builditem.PodmanStatusBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.deployment.util.ExecUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class PodmanProcessor
extends CommonProcessor<PodmanConfig> {
    private static final Logger LOG = Logger.getLogger(PodmanProcessor.class);
    private static final String PODMAN = "podman";
    static final String PODMAN_CONTAINER_IMAGE_NAME = "podman";

    protected String getProcessorImplementation() {
        return "podman";
    }

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem("podman");
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, PodmanBuild.class}, onlyIfNot={NativeBuild.class})
    public void podmanBuildFromJar(PodmanConfig podmanConfig, PodmanStatusBuildItem podmanStatusBuildItem, ContainerImageConfig containerImageConfig, OutputTargetBuildItem out, ContainerImageInfoBuildItem containerImageInfo, CompiledJavaVersionBuildItem compiledJavaVersion, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, Optional<AppCDSResultBuildItem> appCDSResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, JarBuildItem jar) {
        this.buildFromJar(podmanConfig, (ContainerRuntimeStatusBuildItem)podmanStatusBuildItem, containerImageConfig, out, containerImageInfo, buildRequest, pushRequest, artifactResultProducer, containerImageBuilder, packageConfig, new ContainerRuntimeUtil.ContainerRuntime[]{ContainerRuntimeUtil.ContainerRuntime.PODMAN});
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, NativeBuild.class, PodmanBuild.class})
    public void podmanBuildFromNativeImage(PodmanConfig podmanConfig, PodmanStatusBuildItem podmanStatusBuildItem, ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, OutputTargetBuildItem out, Optional<UpxCompressedBuildItem> upxCompressed, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, NativeImageBuildItem nativeImage) {
        this.buildFromNativeImage(podmanConfig, (ContainerRuntimeStatusBuildItem)podmanStatusBuildItem, containerImageConfig, containerImage, buildRequest, pushRequest, out, artifactResultProducer, containerImageBuilder, packageConfig, nativeImage, new ContainerRuntimeUtil.ContainerRuntime[]{ContainerRuntimeUtil.ContainerRuntime.PODMAN});
    }

    protected String createContainerImage(ContainerImageConfig containerImageConfig, PodmanConfig podmanConfig, ContainerImageInfoBuildItem containerImageInfo, OutputTargetBuildItem out, CommonProcessor.DockerfilePaths dockerfilePaths, boolean buildContainerImage, boolean pushContainerImage, PackageConfig packageConfig, String executableName) {
        boolean isMultiPlatformBuild = this.isMultiPlatformBuild(podmanConfig);
        String image = containerImageInfo.getImage();
        if (isMultiPlatformBuild) {
            this.createManifest(image, executableName);
        }
        if (buildContainerImage) {
            String[] podmanBuildArgs = this.getPodmanBuildArgs(image, dockerfilePaths, containerImageConfig, podmanConfig, isMultiPlatformBuild);
            this.buildImage(containerImageInfo, out, executableName, podmanBuildArgs, true);
        }
        if (pushContainerImage) {
            this.loginToRegistryIfNeeded(containerImageConfig, containerImageInfo, executableName);
            if (isMultiPlatformBuild) {
                this.pushManifests(containerImageInfo, executableName);
            } else {
                this.pushImages(containerImageInfo, executableName, podmanConfig);
            }
        }
        return image;
    }

    protected String[] createPushArgs(String image, PodmanConfig config) {
        return new String[]{"push", image, String.format("--tls-verify=%b", config.tlsVerify())};
    }

    private String[] getPodmanBuildArgs(String image, CommonProcessor.DockerfilePaths dockerfilePaths, ContainerImageConfig containerImageConfig, PodmanConfig podmanConfig, boolean isMultiPlatformBuild) {
        List podmanBuildArgs = this.getContainerCommonBuildArgs(image, dockerfilePaths, containerImageConfig, podmanConfig, !isMultiPlatformBuild);
        podmanConfig.platform().filter(platform -> !platform.isEmpty()).ifPresent(platform -> {
            podmanBuildArgs.addAll(List.of("--platform", String.join((CharSequence)",", platform)));
            if (isMultiPlatformBuild) {
                podmanBuildArgs.addAll(List.of("--manifest", image));
            }
        });
        podmanBuildArgs.add(dockerfilePaths.dockerExecutionPath().toAbsolutePath().toString());
        return (String[])podmanBuildArgs.toArray(String[]::new);
    }

    private void pushManifests(ContainerImageInfoBuildItem containerImageInfo, String executableName) {
        Stream.concat(containerImageInfo.getAdditionalImageTags().stream(), Stream.of(containerImageInfo.getImage())).forEach(manifestToPush -> this.pushManifest((String)manifestToPush, executableName));
    }

    private void pushManifest(String image, String executableName) {
        String[] pushArgs = new String[]{"manifest", "push", image};
        boolean pushSuccessful = ExecUtil.exec((String)executableName, (String[])pushArgs);
        if (!pushSuccessful) {
            throw this.containerRuntimeException(executableName, pushArgs);
        }
        LOG.infof("Successfully pushed podman manifest %s", (Object)image);
    }

    private void createManifest(String image, String executableName) {
        CharSequence[] manifestCreateArgs = new String[]{"manifest", "create", image};
        LOG.infof("Running '%s %s'", (Object)executableName, (Object)String.join((CharSequence)" ", manifestCreateArgs));
        boolean createManifestSuccessful = ExecUtil.exec((String)executableName, (String[])manifestCreateArgs);
        if (!createManifestSuccessful) {
            throw this.containerRuntimeException(executableName, (String[])manifestCreateArgs);
        }
    }

    private boolean isMultiPlatformBuild(PodmanConfig podmanConfig) {
        return podmanConfig.platform().map(List::size).orElse(0) >= 2;
    }
}

