/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.s2i;

import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

public class RemoveEnvVarDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private final String envVarName;

    public RemoveEnvVarDecorator(String envVarName) {
        this(ANY, envVarName);
    }

    public RemoveEnvVarDecorator(String name, String envVarName) {
        super(name);
        this.envVarName = envVarName;
    }

    public void andThenVisit(ContainerFluent<?> container) {
        container.removeMatchingFromEnv(e -> e.getName().equals(this.envVarName));
    }

    public String getEnvVarKey() {
        return this.envVarName;
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddEnvVarDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.envVarName == null ? 0 : this.envVarName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoveEnvVarDecorator other = (RemoveEnvVarDecorator)((Object)obj);
        return !(this.envVarName == null ? other.envVarName != null : !this.envVarName.equals(other.envVarName));
    }
}

