/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.s2i.deployment;

import io.dekorate.DekorateException;
import io.dekorate.deps.commons.compress.archivers.ArchiveEntry;
import io.dekorate.deps.commons.compress.archivers.tar.TarArchiveEntry;
import io.dekorate.deps.commons.compress.archivers.tar.TarArchiveOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsoup.helper.StringUtil;

public class PackageUtil {
    private static final String DEFAULT_DOCKERFILE = "Dockerfile";
    private static final String DOCKER_IGNORE = ".dockerignore";
    protected static final String DEFAULT_TEMP_DIR = System.getProperty("java.io.tmpdir", "/tmp");
    protected static final String DOCKER_PREFIX = "docker-";
    protected static final String BZIP2_SUFFIX = ".tar.bzip2";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static File packageFile(String path) {
        return PackageUtil.packageFile(path, null);
    }

    public static File packageFile(final String path, final String base) {
        try {
            final Path root = Paths.get(path, new String[0]).getParent();
            File tempFile = Files.createTempFile(Paths.get(DEFAULT_TEMP_DIR, new String[0]), DOCKER_PREFIX, BZIP2_SUFFIX, new FileAttribute[0]).toFile();
            try (final TarArchiveOutputStream tout = PackageUtil.buildTarStream(tempFile);){
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String absolutePath = file.toAbsolutePath().toString();
                        if (!path.equals(absolutePath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path relativePath = root.relativize(file);
                        boolean hasBasePath = !StringUtil.isBlank((String)base);
                        TarArchiveEntry entry = hasBasePath ? new TarArchiveEntry(base + File.separator + file.toFile()) : new TarArchiveEntry(file.toFile());
                        entry.setName(hasBasePath ? base + File.separator + relativePath.toString() : relativePath.toString());
                        if (file.toFile().canExecute()) {
                            entry.setMode(entry.getMode() | 0x1ED);
                        }
                        entry.setSize(attrs.size());
                        PackageUtil.putTarEntry(tout, entry, file);
                        return FileVisitResult.CONTINUE;
                    }
                });
                tout.flush();
            }
            return tempFile;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    public static File packageFile(Path root, Path ... additional) {
        return PackageUtil.packageFile(root, null, additional);
    }

    public static File packageFile(final Path root, final String base, Path ... additional) {
        try {
            final Set includes = Arrays.stream(additional).map(p -> p.toAbsolutePath().toString()).collect(Collectors.toSet());
            File tempFile = Files.createTempFile(Paths.get(DEFAULT_TEMP_DIR, new String[0]), DOCKER_PREFIX, BZIP2_SUFFIX, new FileAttribute[0]).toFile();
            try (final TarArchiveOutputStream tout = PackageUtil.buildTarStream(tempFile);){
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String absolutePath = file.toAbsolutePath().toString();
                        if (!PackageUtil.shouldInclude(absolutePath, includes)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path relativePath = root.relativize(file);
                        boolean hasBasePath = !StringUtil.isBlank((String)base);
                        TarArchiveEntry entry = hasBasePath ? new TarArchiveEntry(base + File.separator + file.toFile()) : new TarArchiveEntry(file.toFile());
                        entry.setName(hasBasePath ? base + File.separator + relativePath.toString() : relativePath.toString());
                        if (file.toFile().canExecute()) {
                            entry.setMode(entry.getMode() | 0x1ED);
                        }
                        entry.setSize(attrs.size());
                        PackageUtil.putTarEntry(tout, entry, file);
                        return FileVisitResult.CONTINUE;
                    }
                });
                tout.flush();
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void putTarEntry(TarArchiveOutputStream tarArchiveOutputStream, TarArchiveEntry tarArchiveEntry, Path inputPath) throws IOException {
        tarArchiveEntry.setSize(Files.size(inputPath));
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        Files.copy(inputPath, (OutputStream)tarArchiveOutputStream);
        tarArchiveOutputStream.closeArchiveEntry();
    }

    public static TarArchiveOutputStream buildTarStream(File outputPath) throws IOException {
        FileOutputStream fout = new FileOutputStream(outputPath);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        TarArchiveOutputStream stream = new TarArchiveOutputStream((OutputStream)bout);
        stream.setLongFileMode(3);
        return stream;
    }

    public static void tar(Path inputPath, Path outputPath) throws IOException {
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("File not found " + inputPath);
        }
        try (TarArchiveOutputStream tarArchiveOutputStream = PackageUtil.buildTarStream(outputPath.toFile());){
            if (!Files.isDirectory(inputPath, new LinkOption[0])) {
                TarArchiveEntry tarEntry = new TarArchiveEntry(inputPath.toFile().getName());
                if (inputPath.toFile().canExecute()) {
                    tarEntry.setMode(tarEntry.getMode() | 0x1ED);
                }
                PackageUtil.putTarEntry(tarArchiveOutputStream, tarEntry, inputPath);
            } else {
                Files.walkFileTree(inputPath, new TarDirWalker(inputPath, tarArchiveOutputStream));
            }
            tarArchiveOutputStream.flush();
        }
    }

    private static boolean shouldInclude(String candidate, String path) {
        return candidate.equals(path) || candidate.startsWith(path);
    }

    private static boolean shouldInclude(String candidate, Set<String> paths) {
        for (String path : paths) {
            if (!PackageUtil.shouldInclude(candidate, path)) continue;
            return true;
        }
        return false;
    }

    public static class TarDirWalker
    extends SimpleFileVisitor<Path> {
        private Path basePath;
        private TarArchiveOutputStream tarArchiveOutputStream;

        public TarDirWalker(Path basePath, TarArchiveOutputStream tarArchiveOutputStream) {
            this.basePath = basePath;
            this.tarArchiveOutputStream = tarArchiveOutputStream;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!dir.equals(this.basePath)) {
                this.tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(this.basePath.relativize(dir).toFile()));
                this.tarArchiveOutputStream.closeArchiveEntry();
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            TarArchiveEntry tarEntry = new TarArchiveEntry(this.basePath.relativize(file).toFile());
            tarEntry.setSize(attrs.size());
            if (file.toFile().canExecute()) {
                tarEntry.setMode(tarEntry.getMode() | 0x1ED);
            }
            PackageUtil.putTarEntry(this.tarArchiveOutputStream, tarEntry, file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            this.tarArchiveOutputStream.close();
            throw exc;
        }
    }
}

