/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.s2i.deployment;

import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class S2iConfig {
    public static final String DEFAULT_BASE_JVM_JDK11_IMAGE = "registry.access.redhat.com/ubi8/openjdk-11";
    public static final String DEFAULT_BASE_JVM_JDK17_IMAGE = "registry.access.redhat.com/ubi8/openjdk-17";
    public static final String DEFAULT_BASE_NATIVE_IMAGE = "quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0";
    public static final String DEFAULT_NATIVE_TARGET_FILENAME = "application";
    @ConfigItem
    public Optional<String> baseJvmImage;
    @ConfigItem(defaultValue="quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0")
    public String baseNativeImage;
    @ConfigItem(defaultValue="-Djava.util.logging.manager=org.jboss.logmanager.LogManager")
    public List<String> jvmArguments;
    @ConfigItem
    public Optional<List<String>> jvmAdditionalArguments;
    @ConfigItem
    public Optional<List<String>> nativeArguments;
    @ConfigItem(defaultValue="/deployments/")
    public String jarDirectory;
    @ConfigItem
    public Optional<String> jarFileName;
    @ConfigItem(defaultValue="/home/quarkus/")
    public String nativeBinaryDirectory;
    @ConfigItem
    public Optional<String> nativeBinaryFileName;
    @ConfigItem(defaultValue="PT5M")
    Duration buildTimeout;

    public static String getDefaultJvmImage(CompiledJavaVersionBuildItem.JavaVersion version) {
        switch (version.isJava17OrHigher()) {
            case TRUE: {
                return DEFAULT_BASE_JVM_JDK17_IMAGE;
            }
        }
        return DEFAULT_BASE_JVM_JDK11_IMAGE;
    }

    public boolean hasDefaultBaseJvmImage() {
        return this.baseJvmImage.isPresent();
    }

    public boolean hasDefaultBaseNativeImage() {
        return this.baseNativeImage.equals(DEFAULT_BASE_NATIVE_IMAGE);
    }

    public List<String> getEffectiveJvmArguments() {
        ArrayList<String> effectiveJvmArguments = new ArrayList<String>(this.jvmArguments);
        this.jvmAdditionalArguments.ifPresent(effectiveJvmArguments::addAll);
        return effectiveJvmArguments;
    }
}

