/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.s2i.deployment;

import io.quarkus.container.image.deployment.util.ImageUtil;
import java.util.Optional;

public enum S2iBaseNativeImage {
    QUARKUS("quarkus/ubi-quarkus-native-binary-s2i:2.0", "application", "QUARKUS_HOME", "QUARKUS_OPTS");

    private final String image;
    private final String fixedNativeBinaryName;
    private final String homeDirEnvVar;
    private final String optsEnvVar;

    public static Optional<S2iBaseNativeImage> findMatching(String image) {
        for (S2iBaseNativeImage candidate : S2iBaseNativeImage.values()) {
            if (!ImageUtil.getRepository((String)candidate.getImage()).equals(ImageUtil.getRepository((String)image))) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    private S2iBaseNativeImage(String image, String fixedNativeBinaryName, String homeDirEnvVar, String optsEnvVar) {
        this.image = image;
        this.fixedNativeBinaryName = fixedNativeBinaryName;
        this.homeDirEnvVar = homeDirEnvVar;
        this.optsEnvVar = optsEnvVar;
    }

    public String getImage() {
        return this.image;
    }

    public String getFixedNativeBinaryName() {
        return this.fixedNativeBinaryName;
    }

    public String getHomeDirEnvVar() {
        return this.homeDirEnvVar;
    }

    public String getOptsEnvVar() {
        return this.optsEnvVar;
    }
}

