/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppArtifact;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

public final class ApplicationInfoUtil {
    public static final String APPLICATION_INFO_PROPERTIES = "application-info.properties";
    public static final String META_INF = "META-INF";
    public static final String ARTIFACT_ID_KEY = "artifactId";
    public static final String VERSION_KEY = "version";

    private ApplicationInfoUtil() {
    }

    public static void writeApplicationInfoProperties(AppArtifact appArtifact, Path appClassesDir) {
        Properties properties = new Properties();
        if (appArtifact != null) {
            properties.setProperty(ARTIFACT_ID_KEY, appArtifact.getArtifactId());
            properties.setProperty(VERSION_KEY, appArtifact.getVersion());
        }
        try {
            appClassesDir.resolve(META_INF).toFile().mkdir();
            File file = appClassesDir.resolve(META_INF).resolve(APPLICATION_INFO_PROPERTIES).toFile();
            properties.store(new FileOutputStream(file), "Generated file; do not edit manually");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

