/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Optional;

public class BooleanConfigType
extends LeafConfigType {
    private static final MethodDescriptor BOOL_VALUE_METHOD = MethodDescriptor.ofMethod(Boolean.class, (String)"booleanValue", Boolean.TYPE, (Class[])new Class[0]);
    final String defaultValue;

    public BooleanConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue) {
        super(containingName, container, consumeSegment);
        this.defaultValue = defaultValue;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.setBoolean(enclosing, config.getOptionalValue(name.toString(), Boolean.class).orElse(Boolean.FALSE));
        }
        catch (IllegalAccessException e) {
            throw BooleanConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.checkCast(body.invokeVirtualMethod(SRC_GET_OPT_METHOD, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(Boolean.class)}), Optional.class);
        ResultHandle convertedDefault = body.readStaticField(FieldDescriptor.of(Boolean.class, (String)"FALSE", Boolean.class));
        ResultHandle defaultedValue = body.checkCast(body.invokeVirtualMethod(OPT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{convertedDefault}), Boolean.class);
        ResultHandle booleanValue = body.invokeVirtualMethod(BOOL_VALUE_METHOD, defaultedValue, new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, booleanValue});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getItemClass() {
        return Boolean.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            field.setBoolean(enclosing, (Boolean)config.convert(ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), Boolean.class));
        }
        catch (IllegalAccessException e) {
            throw BooleanConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle value = body.invokeVirtualMethod(BOOL_VALUE_METHOD, body.checkCast(this.getConvertedDefault(body, cache, config), Boolean.class), new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, value});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(BOOL_VALUE_METHOD, body.checkCast(this.getConvertedDefault(body, cache, smallRyeConfig), Boolean.class), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle cache, ResultHandle config) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(Boolean.class)}), Boolean.class);
    }
}

