/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.ObjectConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.wildfly.common.Assert;

public class OptionalObjectConfigType
extends ObjectConfigType {
    public OptionalObjectConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, Class<?> expectedType) {
        super(containingName, container, consumeSegment, defaultValue, expectedType);
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            if (this.defaultValue.isEmpty()) {
                field.set(enclosing, Optional.empty());
            } else {
                field.set(enclosing, Optional.ofNullable(config.convert(ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), this.expectedType)));
            }
        }
        catch (IllegalAccessException e) {
            throw OptionalObjectConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle optValue = this.defaultValue.isEmpty() ? body.invokeStaticMethod(OPT_EMPTY_METHOD, new ResultHandle[0]) : body.invokeStaticMethod(OPT_OF_NULLABLE_METHOD, new ResultHandle[]{body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(this.expectedType)})});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, optValue});
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.set(enclosing, config.getOptionalValue(name.toString(), this.expectedType));
        }
        catch (IllegalAccessException e) {
            throw OptionalObjectConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.invokeVirtualMethod(SRC_GET_OPT_METHOD, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(this.expectedType)});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, optionalValue});
    }

    @Override
    void acceptConfigurationValueIntoMap(Map<String, Object> enclosing, NameIterator name, SmallRyeConfig config) {
        throw Assert.unsupported();
    }

    @Override
    void generateAcceptConfigurationValueIntoMap(BytecodeCreator body, ResultHandle enclosing, ResultHandle name, ResultHandle config) {
        throw Assert.unsupported();
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle config) {
        if (this.defaultValue.isEmpty()) {
            return body.invokeStaticMethod(OPT_EMPTY_METHOD, new ResultHandle[0]);
        }
        return body.invokeStaticMethod(OPT_OF_NULLABLE_METHOD, new ResultHandle[]{body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(this.expectedType)})});
    }
}

