/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FileUtil {
    public static void deleteDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.delete(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    Files.delete(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

