/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static Iterable<Class<?>> classesNamedIn(ClassLoader classLoader, String fileName) throws IOException, ClassNotFoundException {
        ArrayList list = new ArrayList();
        for (String className : ServiceUtil.classNamesNamedIn(classLoader, fileName)) {
            list.add(Class.forName(className, true, classLoader));
        }
        return Collections.unmodifiableList(list);
    }

    public static Set<String> classNamesNamedIn(ClassLoader classLoader, String fileName) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(fileName);
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                Throwable throwable2 = null;
                try {
                    InputStreamReader isr = new InputStreamReader((InputStream)bis, StandardCharsets.UTF_8);
                    Throwable throwable3 = null;
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        Throwable throwable4 = null;
                        try {
                            ServiceUtil.readStream(classNames, br);
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (br == null) continue;
                            if (throwable4 != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            br.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (isr == null) continue;
                        if (throwable3 != null) {
                            try {
                                isr.close();
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        isr.close();
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (bis == null) continue;
                    if (throwable2 != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    bis.close();
                }
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                    }
                    continue;
                }
                is.close();
            }
        }
        return Collections.unmodifiableSet(classNames);
    }

    public static Set<String> classNamesNamedIn(Path path) throws IOException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ServiceUtil.readStream(set, br);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Collections.emptySet();
        }
        return set;
    }

    private static void readStream(Set<String> classNames, BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            int commentMarkerIndex = line.indexOf(35);
            if (commentMarkerIndex > 0) {
                line = line.substring(commentMarkerIndex);
            }
            if ((line = line.trim()).isEmpty()) continue;
            classNames.add(line);
        }
    }
}

