/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.runner.RuntimeClassLoader;
import io.quarkus.runner.TransformerTarget;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jboss.builder.BuildChainBuilder;
import org.jboss.builder.BuildResult;
import org.objectweb.asm.ClassVisitor;

public class RuntimeRunner
implements Runnable,
Closeable {
    private final Path target;
    private final ClassLoader loader;
    private final ClassOutput classOutput;
    private final TransformerTarget transformerTarget;
    private Closeable closeTask;
    private final List<Path> additionalArchives;
    private final List<Consumer<BuildChainBuilder>> chainCustomizers;
    private final LaunchMode launchMode;

    public RuntimeRunner(Builder builder) {
        this.target = builder.target;
        this.additionalArchives = new ArrayList<Path>(builder.additionalArchives);
        this.chainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.chainCustomizers);
        this.launchMode = builder.launchMode;
        if (builder.classOutput == null) {
            RuntimeClassLoader runtimeClassLoader = new RuntimeClassLoader(builder.classLoader, this.target, builder.frameworkClassesPath, builder.transformerCache);
            this.loader = runtimeClassLoader;
            this.classOutput = runtimeClassLoader;
            this.transformerTarget = runtimeClassLoader;
        } else {
            this.classOutput = builder.classOutput;
            this.transformerTarget = builder.transformerTarget;
            this.loader = builder.classLoader;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeTask != null) {
            this.closeTask.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            Application application;
            QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder();
            builder.setRoot(this.target);
            builder.setClassLoader(this.loader);
            builder.setOutput(this.classOutput);
            builder.setLaunchMode(this.launchMode);
            for (Path path : this.additionalArchives) {
                builder.addAdditionalApplicationArchive(path);
            }
            for (Consumer consumer : this.chainCustomizers) {
                builder.addBuildChainCustomizer(consumer);
            }
            builder.addFinal(BytecodeTransformerBuildItem.class).addFinal(ApplicationClassNameBuildItem.class);
            BuildResult result = builder.build().run();
            List list = result.consumeMulti(BytecodeTransformerBuildItem.class);
            if (!list.isEmpty()) {
                HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions = new HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>>();
                for (BytecodeTransformerBuildItem i : list) {
                    functions.computeIfAbsent(i.getClassToTransform(), f -> new ArrayList()).add(i.getVisitorFunction());
                }
                this.transformerTarget.setTransformers(functions);
            }
            Class<Application> appClass = this.loader.loadClass(((ApplicationClassNameBuildItem)result.consume(ApplicationClassNameBuildItem.class)).getClassName()).asSubclass(Application.class);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.loader);
                application = appClass.newInstance();
                application.start(null);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            this.closeTask = new Closeable(){

                @Override
                public void close() {
                    application.stop();
                }
            };
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClassLoader classLoader;
        private Path target;
        private Path frameworkClassesPath;
        private Path transformerCache;
        private LaunchMode launchMode = LaunchMode.NORMAL;
        private final List<Path> additionalArchives = new ArrayList<Path>();
        private final List<Consumer<BuildChainBuilder>> chainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        private ClassOutput classOutput;
        private TransformerTarget transformerTarget;

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setTarget(Path target) {
            this.target = target;
            return this;
        }

        public Builder setFrameworkClassesPath(Path frameworkClassesPath) {
            this.frameworkClassesPath = frameworkClassesPath;
            return this;
        }

        public Builder setTransformerCache(Path transformerCache) {
            this.transformerCache = transformerCache;
            return this;
        }

        public Builder addAdditionalArchive(Path additionalArchive) {
            this.additionalArchives.add(additionalArchive);
            return this;
        }

        public Builder addAdditionalArchives(Collection<Path> additionalArchive) {
            this.additionalArchives.addAll(this.additionalArchives);
            return this;
        }

        public Builder addChainCustomizer(Consumer<BuildChainBuilder> chainCustomizer) {
            this.chainCustomizers.add(chainCustomizer);
            return this;
        }

        public Builder addChainCustomizers(Collection<Consumer<BuildChainBuilder>> chainCustomizer) {
            this.chainCustomizers.addAll(chainCustomizer);
            return this;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public Builder setClassOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder setTransformerTarget(TransformerTarget transformerTarget) {
            this.transformerTarget = transformerTarget;
            return this;
        }

        public RuntimeRunner build() {
            return new RuntimeRunner(this);
        }
    }
}

