/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.substrate;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ServiceProviderBuildItem
extends MultiBuildItem {
    public static final String SPI_ROOT = "META-INF/services/";
    private final String serviceInterface;
    private final List<String> providers;

    public ServiceProviderBuildItem(String serviceInterfaceClassName, String ... providerClassNames) {
        this.serviceInterface = Objects.requireNonNull(serviceInterfaceClassName, "The service interface must not be `null`");
        this.providers = Arrays.asList((Object[])Objects.requireNonNull(providerClassNames));
        if (this.serviceInterface.length() == 0) {
            throw new IllegalArgumentException("The serviceDescriptorFile interface cannot be blank");
        }
        this.providers.forEach(s -> {
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("The provider class name cannot be blank");
            }
        });
    }

    public List<String> providers() {
        return this.providers;
    }

    public String serviceDescriptorFile() {
        return SPI_ROOT + this.serviceInterface;
    }
}

