/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.OptionalDouble;
import org.wildfly.common.Assert;

public class DoubleConfigType
extends LeafConfigType {
    private static final MethodDescriptor OPTDOUBLE_OR_ELSE_METHOD = MethodDescriptor.ofMethod(OptionalDouble.class, (String)"orElse", Double.TYPE, (Class[])new Class[]{Double.TYPE});
    private static final MethodDescriptor DOUBLE_VALUE_METHOD = MethodDescriptor.ofMethod(Double.class, (String)"doubleValue", Double.TYPE, (Class[])new Class[0]);
    final String defaultValue;

    public DoubleConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue) {
        super(containingName, container, consumeSegment);
        Assert.checkNotEmptyParam((String)"defaultValue", (String)defaultValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.setDouble(enclosing, ((OptionalDouble)config.getValue(name.toString(), OptionalDouble.class)).orElse(0.0));
        }
        catch (IllegalAccessException e) {
            throw DoubleConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.checkCast(body.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(OptionalDouble.class)}), OptionalDouble.class);
        ResultHandle doubleValue = body.invokeVirtualMethod(OPTDOUBLE_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{body.load(0.0)});
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, doubleValue});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getItemClass() {
        return Double.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            field.setDouble(enclosing, (Double)config.convert(ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), Double.class));
        }
        catch (IllegalAccessException e) {
            throw DoubleConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(DOUBLE_VALUE_METHOD, this.getConvertedDefault(body, cache, config), new ResultHandle[0])});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(DOUBLE_VALUE_METHOD, this.getConvertedDefault(body, cache, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle cache, ResultHandle config) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(Double.class)}), Double.class);
    }
}

