/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Map;

public class ObjectConfigType
extends LeafConfigType {
    final String defaultValue;
    final Class<?> expectedType;

    public ObjectConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, Class<?> expectedType) {
        super(containingName, container, consumeSegment);
        this.defaultValue = defaultValue;
        this.expectedType = expectedType;
    }

    @Override
    public Class<?> getItemClass() {
        return this.expectedType;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            field.set(enclosing, config.convert(ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), this.expectedType));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(this.expectedType)})});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, smallRyeConfig, new ResultHandle[]{cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(this.expectedType)}), this.expectedType);
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        if (this.isConsumeSegment()) {
            name.previous();
        }
        this.getContainer().acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        this.getContainer().generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.set(enclosing, this.getValue(name, config, this.expectedType));
        }
        catch (IllegalAccessException e) {
            throw ObjectConfigType.toError(e);
        }
    }

    @Override
    void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, this.generateGetValue(body, name, config)});
    }

    @Override
    void acceptConfigurationValueIntoMap(Map<String, Object> enclosing, NameIterator name, SmallRyeConfig config) {
        enclosing.put(name.getNextSegment(), this.getValue(name, config, this.expectedType));
    }

    @Override
    void generateAcceptConfigurationValueIntoMap(BytecodeCreator body, ResultHandle enclosing, ResultHandle name, ResultHandle config) {
        body.invokeInterfaceMethod(MAP_PUT_METHOD, enclosing, new ResultHandle[]{body.invokeVirtualMethod(NI_GET_NEXT_SEGMENT, name, new ResultHandle[0]), this.generateGetValue(body, name, config)});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    private <T> T getValue(NameIterator name, SmallRyeConfig config, Class<T> expectedType) {
        return config.getOptionalValue(name.toString(), expectedType).orElse(null);
    }

    private ResultHandle generateGetValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.invokeVirtualMethod(SRC_GET_OPT_METHOD, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(this.expectedType)});
        return body.invokeVirtualMethod(OPT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{body.loadNull()});
    }
}

