/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ApplicationConfig;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Properties;

public class ApplicationInfoBuildStep {
    private static final String PROPERTIES_FILE_TO_READ = "META-INF" + File.separator + "application-info.properties";

    @BuildStep
    public ApplicationInfoBuildItem create(ApplicationConfig applicationConfig) {
        String userConfiguredName = applicationConfig.name;
        String userConfiguredVersion = applicationConfig.version;
        Properties applicationInfoProperties = this.getApplicationInfoProperties();
        return new ApplicationInfoBuildItem(this.useIfNotEmpty(userConfiguredName, applicationInfoProperties, "artifactId"), this.useIfNotEmpty(userConfiguredVersion, applicationInfoProperties, "version"));
    }

    private Properties getApplicationInfoProperties() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ApplicationInfoBuildStep.class.getClassLoader();
        }
        try {
            Enumeration<URL> resources;
            Properties p = new Properties();
            Enumeration<URL> enumeration = resources = cl == null ? ClassLoader.getSystemResources(PROPERTIES_FILE_TO_READ) : cl.getResources(PROPERTIES_FILE_TO_READ);
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (InputStream is = url.openStream();
                     InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    p.load(isr);
                }
            }
            return p;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read application-info.properties", e);
        }
    }

    private String useIfNotEmpty(String value, Properties properties, String key) {
        return value != null && !value.isEmpty() ? value : properties.getProperty(key, "<<unset>>");
    }
}

