/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.graalvm.nativeimage.ImageInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class StaticInitDebugStep {
    private static final BiFunction<String, ClassVisitor, ClassVisitor> TRANSFORMER = new BiFunction<String, ClassVisitor, ClassVisitor>(){

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            return new ClassVisitor(393216, classVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor outer = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if (name.equals("<clinit>")) {
                        outer.visitMethodInsn(184, ImageInfo.class.getName().replace('.', '/'), "inImageBuildtimeCode", "()Z", false);
                        Label ok = new Label();
                        outer.visitJumpInsn(153, ok);
                        outer.visitTypeInsn(187, "java/lang/Error");
                        outer.visitLdcInsn((Object)"Class initialized during build");
                        outer.visitMethodInsn(183, Error.class.getName().replace('.', '/'), "<init>", "(Ljava/lang/String;)V", false);
                        outer.visitInsn(191);
                    }
                    return outer;
                }
            };
        }
    };

    @BuildStep
    public List<BytecodeTransformerBuildItem> addStaticInitDebug(List<RuntimeInitializedClassBuildItem> classes) {
        ArrayList<BytecodeTransformerBuildItem> outputList = new ArrayList<BytecodeTransformerBuildItem>(classes.size());
        for (RuntimeInitializedClassBuildItem classBuildItem : classes) {
            outputList.add(new BytecodeTransformerBuildItem(classBuildItem.getClassName(), TRANSFORMER));
        }
        return outputList;
    }
}

