/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.runner.TransformerTarget;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class RuntimeClassLoader
extends ClassLoader
implements ClassOutput,
TransformerTarget {
    private static final Logger log = Logger.getLogger(RuntimeClassLoader.class);
    private final Map<String, byte[]> appClasses = new ConcurrentHashMap<String, byte[]>();
    private final Set<String> frameworkClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, byte[]> resources = new ConcurrentHashMap<String, byte[]>();
    private volatile Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = null;
    private final List<Path> applicationClasses;
    private final Path frameworkClassesPath;
    private final Path transformerCache;
    private static final String DEBUG_CLASSES_DIR = System.getProperty("quarkus.debug.generated-classes-dir");
    private final ConcurrentHashMap<String, Future<Class<?>>> loadingClasses = new ConcurrentHashMap();

    public RuntimeClassLoader(ClassLoader parent, List<Path> applicationClasses, Path frameworkClassesPath, Path transformerCache) {
        super(parent);
        this.applicationClasses = applicationClasses;
        this.frameworkClassesPath = frameworkClassesPath;
        this.transformerCache = transformerCache;
    }

    @Override
    public Enumeration<URL> getResources(String nm) throws IOException {
        final String name = nm.startsWith("/") ? nm.substring(1) : nm;
        byte[] data = this.resources.get(name);
        if (data != null) {
            URL url = new URL(null, "quarkus:" + name + "/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream((byte[])RuntimeClassLoader.this.resources.get(name));
                        }
                    };
                }
            });
            return Collections.enumeration(Collections.singleton(url));
        }
        URL appResource = this.findApplicationResource(name);
        if (appResource != null) {
            ArrayList<URL> resources = new ArrayList<URL>();
            resources.add(appResource);
            Enumeration<URL> e = super.getResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
            return Collections.enumeration(resources);
        }
        return super.getResources(name);
    }

    @Override
    public URL getResource(String nm) {
        String name = nm.startsWith("/") ? nm.substring(1) : nm;
        URL appResource = this.findApplicationResource(name);
        if (appResource != null) {
            return appResource;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String nm) {
        String name = nm.startsWith("/") ? nm.substring(1) : nm;
        byte[] data = this.resources.get(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Path i;
        Class<?> ex = this.findLoadedClass(name);
        if (ex != null) {
            return ex;
        }
        if (this.appClasses.containsKey(name)) {
            return this.findClass(name);
        }
        if (this.frameworkClasses.contains(name)) {
            return super.loadClass(name, resolve);
        }
        String fileName = name.replace('.', '/') + ".class";
        Path classLoc = null;
        Iterator<Path> iterator = this.applicationClasses.iterator();
        while (iterator.hasNext() && !Files.exists(classLoc = (i = iterator.next()).resolve(fileName), new LinkOption[0])) {
        }
        if (classLoc != null && Files.exists(classLoc, new LinkOption[0])) {
            CompletableFuture res = new CompletableFuture();
            Future existing = this.loadingClasses.putIfAbsent(name, res);
            if (existing != null) {
                try {
                    return (Class)existing.get();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Failed to load " + name, e);
                }
            }
            try {
                byte[] buf = new byte[1024];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (FileInputStream in = new FileInputStream(classLoc.toFile());){
                    int r;
                    while ((r = in.read(buf)) > 0) {
                        out.write(buf, 0, r);
                    }
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Failed to load class", e);
                }
                byte[] bytes = out.toByteArray();
                bytes = this.handleTransform(name, bytes);
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                res.complete(clazz);
                return clazz;
            }
            catch (RuntimeException e) {
                res.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                res.completeExceptionally(e);
                throw e;
            }
        }
        return super.loadClass(name, resolve);
    }

    private byte[] handleTransform(String name, byte[] bytes) {
        QuarkusClassWriter writer;
        if (this.bytecodeTransformers == null || this.bytecodeTransformers.isEmpty()) {
            return bytes;
        }
        List<BiFunction<String, ClassVisitor, ClassVisitor>> transformers = this.bytecodeTransformers.get(name);
        if (transformers == null) {
            return bytes;
        }
        Path hashPath = null;
        if (this.transformerCache != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] thedigest = md.digest(bytes);
                String hash = Base64.getUrlEncoder().encodeToString(thedigest);
                hashPath = this.transformerCache.resolve(hash);
                if (Files.exists(hashPath, new LinkOption[0])) {
                    return RuntimeClassLoader.readFileContent(hashPath);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to load transformed class from cache", (Throwable)e);
            }
        }
        ClassReader cr = new ClassReader(bytes);
        QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
        for (BiFunction<String, ClassVisitor, ClassVisitor> i : transformers) {
            visitor = i.apply(name, (ClassVisitor)visitor);
        }
        cr.accept((ClassVisitor)visitor, 0);
        byte[] data = writer.toByteArray();
        if (hashPath != null) {
            try {
                File file = hashPath.toFile();
                file.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(file);){
                    out.write(data);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to write class to cache", (Throwable)e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> existing = this.findLoadedClass(name);
        if (existing != null) {
            return existing;
        }
        byte[] bytes = this.appClasses.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            String pkgName = this.getPackageNameFromClassName(name);
            if (pkgName != null && this.getPackage(pkgName) == null) {
                Object object = this.getClassLoadingLock(pkgName);
                synchronized (object) {
                    if (this.getPackage(pkgName) == null) {
                        this.definePackage(pkgName, null, null, null, null, null, null, null);
                    }
                }
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Error e) {
            existing = this.findLoadedClass(name);
            if (existing != null) {
                return existing;
            }
            throw e;
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    @Override
    public void writeClass(boolean applicationClass, String className, byte[] data) {
        if (applicationClass) {
            String dotName = className.replace('/', '.');
            this.appClasses.put(dotName, data);
            if (DEBUG_CLASSES_DIR != null) {
                try {
                    File debugPath = new File(DEBUG_CLASSES_DIR);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File classFile = new File(debugPath, dotName + ".class");
                    FileOutputStream classWriter = new FileOutputStream(classFile);
                    classWriter.write(data);
                    classWriter.close();
                    log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            this.frameworkClasses.add(className.replace('/', '.'));
            Path fileName = this.frameworkClassesPath.resolve(className.replace('.', '/') + ".class");
            try {
                Files.createDirectories(fileName.getParent(), new FileAttribute[0]);
                try (FileOutputStream out = new FileOutputStream(fileName.toFile());){
                    out.write(data);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setTransformers(Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions) {
        this.bytecodeTransformers = functions;
    }

    @Override
    public void writeResource(String name, byte[] data) throws IOException {
        this.resources.put(name, data);
    }

    public static byte[] readFileContent(Path path) throws IOException {
        File file = path.toFile();
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
        }
        int intLength = (int)fileLength;
        try (FileInputStream in = new FileInputStream(file);){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(intLength);
            int reasonableBufferSize = Math.min(intLength, 2048);
            byte[] buf = new byte[reasonableBufferSize];
            while ((r = in.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private URL findApplicationResource(String name) {
        Path i;
        Path resourcePath = null;
        Iterator<Path> iterator = this.applicationClasses.iterator();
        while (iterator.hasNext() && !Files.exists(resourcePath = (i = iterator.next()).resolve(name), new LinkOption[0])) {
        }
        try {
            return resourcePath != null && Files.exists(resourcePath, new LinkOption[0]) ? resourcePath.toUri().toURL() : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        RuntimeClassLoader.registerAsParallelCapable();
    }
}

