/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;

public abstract class ConfigType {
    static final MethodDescriptor NI_PREV_METHOD = MethodDescriptor.ofMethod(NameIterator.class, (String)"previous", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_NEXT_METHOD = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_HAS_NEXT_METHOD = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_GET_NEXT_SEGMENT = MethodDescriptor.ofMethod(NameIterator.class, (String)"getNextSegment", String.class, (Class[])new Class[0]);
    static final MethodDescriptor SRC_CONVERT_METHOD = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"convert", Object.class, (Class[])new Class[]{String.class, Class.class});
    static final MethodDescriptor SRC_GET_OPT_METHOD = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class});
    static final MethodDescriptor SRC_GET_VALUE = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Class.class});
    static final MethodDescriptor SRC_GET_VALUES_METHOD = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValues", Collection.class, (Class[])new Class[]{String.class, Class.class, IntFunction.class});
    static final MethodDescriptor OBJ_TO_STRING_METHOD = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_OR_ELSE_METHOD = MethodDescriptor.ofMethod(Optional.class, (String)"orElse", Object.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor OPT_OF_NULLABLE_METHOD = MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor OPT_EMPTY_METHOD = MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]);
    static final MethodDescriptor MAP_PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    static final MethodDescriptor ECS_CACHE_CTOR = MethodDescriptor.ofConstructor(ExpandingConfigSource.Cache.class, (Class[])new Class[0]);
    private final String containingName;
    private final CompoundConfigType container;
    private final boolean consumeSegment;

    ConfigType(String containingName, CompoundConfigType container, boolean consumeSegment) {
        this.containingName = containingName;
        this.container = container;
        this.consumeSegment = consumeSegment;
    }

    static IllegalAccessError toError(IllegalAccessException e) {
        IllegalAccessError e2 = new IllegalAccessError(e.getMessage());
        e2.setStackTrace(e.getStackTrace());
        return e2;
    }

    static InstantiationError toError(InstantiationException e) {
        InstantiationError e2 = new InstantiationError(e.getMessage());
        e2.setStackTrace(e.getStackTrace());
        return e2;
    }

    public String getContainingName() {
        return this.containingName;
    }

    public CompoundConfigType getContainer() {
        return this.container;
    }

    public <T extends CompoundConfigType> T getContainer(Class<T> expect) {
        CompoundConfigType container = this.getContainer();
        if (expect.isInstance(container)) {
            return (T)((CompoundConfigType)expect.cast(container));
        }
        throw new IllegalStateException("Container is not a supported type; expected " + expect + " but got " + container.getClass());
    }

    public boolean isConsumeSegment() {
        return this.consumeSegment;
    }

    public abstract void load() throws ClassNotFoundException;

    protected static IllegalStateException notLoadedException() {
        return new IllegalStateException("Configuration tree classes not loaded");
    }

    abstract void getDefaultValueIntoEnclosingGroup(Object var1, ExpandingConfigSource.Cache var2, SmallRyeConfig var3, Field var4);

    abstract void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator var1, ResultHandle var2, MethodDescriptor var3, ResultHandle var4, ResultHandle var5);

    public abstract ResultHandle writeInitialization(BytecodeCreator var1, AccessorFinder var2, ResultHandle var3, ResultHandle var4);

    public ConfigDefinition getConfigDefinition() {
        return this.container.getConfigDefinition();
    }
}

