/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.util.IoUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;

public class AnnotationProxyProvider {
    private final ConcurrentMap<DotName, String> annotationLiterals = new ConcurrentHashMap<DotName, String>();
    private final ConcurrentMap<DotName, ClassInfo> annotationClasses = new ConcurrentHashMap<DotName, ClassInfo>();
    private final ConcurrentMap<String, Boolean> generatedLiterals = new ConcurrentHashMap<String, Boolean>();
    private final ClassLoader classLoader;
    private final IndexView index;
    private final Indexer indexer;

    AnnotationProxyProvider(IndexView index) {
        this.index = index;
        this.indexer = new Indexer();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = AnnotationProxy.class.getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public <A extends Annotation> AnnotationProxyBuilder<A> builder(AnnotationInstance annotationInstance, Class<A> annotationType) {
        if (!annotationInstance.name().toString().equals(annotationType.getName())) {
            throw new IllegalArgumentException("Annotation instance " + annotationInstance + " does not match annotation type " + annotationType.getName());
        }
        ClassInfo annotationClass = this.annotationClasses.computeIfAbsent(annotationInstance.name(), name -> {
            ClassInfo clazz = this.index.getClassByName(name);
            if (clazz == null) {
                try (InputStream annotationStream = IoUtil.readClass(this.classLoader, name.toString());){
                    clazz = this.indexer.index(annotationStream);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to index: " + name, e);
                }
            }
            return clazz;
        });
        String annotationLiteral = this.annotationLiterals.computeIfAbsent(annotationInstance.name(), name -> name.toString().replace('.', '/') + "_Proxy_AnnotationLiteral");
        return new AnnotationProxyBuilder<A>(annotationInstance, annotationType, annotationLiteral, annotationClass);
    }

    public class AnnotationProxyBuilder<A> {
        private final ClassInfo annotationClass;
        private final String annotationLiteral;
        private final AnnotationInstance annotationInstance;
        private final Class<A> annotationType;
        private final Map<String, Object> defaultValues = new HashMap<String, Object>();

        AnnotationProxyBuilder(AnnotationInstance annotationInstance, Class<A> annotationType, String annotationLiteral, ClassInfo annotationClass) {
            this.annotationInstance = annotationInstance;
            this.annotationType = annotationType;
            this.annotationLiteral = annotationLiteral;
            this.annotationClass = annotationClass;
        }

        public AnnotationProxyBuilder<A> withDefaultValue(String name, Object value) {
            if (this.annotationInstance.value(name) == null) {
                this.defaultValues.put(name, value);
            }
            return this;
        }

        public A build(ClassOutput classOutput) {
            AnnotationProxyProvider.this.generatedLiterals.computeIfAbsent(this.annotationLiteral, generatedName -> {
                String name = this.annotationInstance.name().toString();
                String signature = String.format("Ljavax/enterprise/util/AnnotationLiteral<L%1$s;>;L%1$s;", name.replace('.', '/'));
                ClassCreator literal = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AnnotationLiteral.class).interfaces(new String[]{name}).signature(signature).build();
                List constructorParams = this.annotationClass.methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList());
                MethodCreator constructor = literal.getMethodCreator("<init>", (Object)"V", constructorParams.stream().map(m -> m.returnType().name().toString()).toArray());
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ListIterator iterator = constructorParams.listIterator();
                while (iterator.hasNext()) {
                    MethodInfo param = (MethodInfo)iterator.next();
                    String returnType = param.returnType().name().toString();
                    literal.getFieldCreator(param.name(), returnType).setModifiers(18);
                    constructor.writeInstanceField(FieldDescriptor.of((String)literal.getClassName(), (String)param.name(), (String)returnType), constructor.getThis(), constructor.getMethodParam(iterator.previousIndex()));
                    MethodCreator value = (MethodCreator)literal.getMethodCreator(param.name(), returnType, new String[0]).setModifiers(1);
                    value.returnValue(value.readInstanceField(FieldDescriptor.of((String)literal.getClassName(), (String)param.name(), (String)returnType), value.getThis()));
                }
                constructor.returnValue(null);
                literal.close();
                return Boolean.TRUE;
            });
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = AnnotationProxy.class.getClassLoader();
            }
            return (A)Proxy.newProxyInstance(classLoader, new Class[]{this.annotationType, AnnotationProxy.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    switch (method.getName()) {
                        case "getAnnotationLiteralType": {
                            return AnnotationProxyBuilder.this.annotationLiteral;
                        }
                        case "getAnnotationClass": {
                            return AnnotationProxyBuilder.this.annotationClass;
                        }
                        case "getAnnotationInstance": {
                            return AnnotationProxyBuilder.this.annotationInstance;
                        }
                        case "getDefaultValues": {
                            return AnnotationProxyBuilder.this.defaultValues;
                        }
                    }
                    throw new UnsupportedOperationException("Method " + method + " not implemented");
                }
            });
        }
    }

    public static interface AnnotationProxy {
        public String getAnnotationLiteralType();

        public ClassInfo getAnnotationClass();

        public AnnotationInstance getAnnotationInstance();

        public Map<String, Object> getDefaultValues();
    }
}

