/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BuildTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.BuildTimeRunTimeFixedConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationBuildItem;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.deployment.configuration.LeafConfigType;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;

public class ConfigDescriptionBuildStep {
    @BuildStep
    List<ConfigDescriptionBuildItem> createConfigDescriptions(RunTimeConfigurationBuildItem runtimeConfig, BuildTimeConfigurationBuildItem buildTimeConfig, BuildTimeRunTimeFixedConfigurationBuildItem buildTimeRuntimeConfig) throws Exception {
        Properties javadoc = new Properties();
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/quarkus-javadoc.properties");
        while (resources.hasMoreElements()) {
            InputStream in = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                javadoc.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        ArrayList<ConfigDescriptionBuildItem> ret = new ArrayList<ConfigDescriptionBuildItem>();
        this.processConfig(runtimeConfig.getConfigDefinition(), ret, javadoc);
        this.processConfig(buildTimeConfig.getConfigDefinition(), ret, javadoc);
        this.processConfig(buildTimeRuntimeConfig.getConfigDefinition(), ret, javadoc);
        return ret;
    }

    private void processConfig(ConfigDefinition configDefinition, final List<ConfigDescriptionBuildItem> ret, final Properties javadoc) {
        configDefinition.getLeafPatterns().forEach(new Consumer<LeafConfigType>(){

            @Override
            public void accept(LeafConfigType leafConfigType) {
                ret.add(new ConfigDescriptionBuildItem("quarkus." + leafConfigType.getConfigKey(), leafConfigType.getItemClass(), leafConfigType.getDefaultValueString(), javadoc.getProperty(leafConfigType.getJavadocKey())));
            }
        });
    }
}

