/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jboss.logging.Logger;

public class NativeImageBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageBuildStep.class);
    private static final String DEBUG_BUILD_PROCESS_PORT = "5005";
    private static final String GRAALVM_HOME = "GRAALVM_HOME";
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private static final String PATH = "PATH";

    @BuildStep(onlyIf={NativeBuild.class})
    ArtifactResultBuildItem result(NativeImageBuildItem image) {
        return new ArtifactResultBuildItem(image.getPath(), "native", Collections.emptyMap());
    }

    @BuildStep
    public NativeImageBuildItem build(NativeConfig nativeConfig, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, List<NativeImageSystemPropertyBuildItem> nativeImageProperties) {
        List<Object> nativeImage;
        Path runnerJar = nativeImageSourceJarBuildItem.getPath();
        log.info((Object)("Building native image from " + runnerJar));
        Path outputDir = nativeImageSourceJarBuildItem.getPath().getParent();
        String runnerJarName = runnerJar.getFileName().toString();
        boolean vmVersionOutOfDate = this.isThisGraalVMVersionObsolete();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String noPIE = "";
        if (!"".equals(nativeConfig.containerRuntime) || nativeConfig.containerBuild) {
            String containerRuntime = nativeConfig.containerRuntime.isEmpty() ? "docker" : nativeConfig.containerRuntime;
            nativeImage = new ArrayList();
            Collections.addAll(nativeImage, containerRuntime, "run", "-v", outputDir.toAbsolutePath() + ":/project:z");
            if (IS_LINUX) {
                if ("docker".equals(containerRuntime)) {
                    String gid;
                    String uid = NativeImageBuildStep.getLinuxID("-ur");
                    if (uid != null & (gid = NativeImageBuildStep.getLinuxID("-gr")) != null & !"".equals(uid) & !"".equals(gid)) {
                        Collections.addAll(nativeImage, "--user", uid + ":" + gid);
                    }
                } else if ("podman".equals(containerRuntime)) {
                    nativeImage.add("--userns=keep-id");
                }
            }
            nativeImage.addAll(nativeConfig.containerRuntimeOptions);
            if (nativeConfig.debugBuildProcess && nativeConfig.publishDebugBuildProcessPort) {
                nativeImage.add("--publish=5005:5005");
            }
            Collections.addAll(nativeImage, "--rm", nativeConfig.builderImage);
        } else {
            if (IS_LINUX) {
                noPIE = NativeImageBuildStep.detectNoPIE();
            }
            String graal = nativeConfig.graalvmHome;
            File java = nativeConfig.javaHome;
            if (graal != null) {
                env.put(GRAALVM_HOME, graal);
            } else {
                graal = env.get(GRAALVM_HOME);
            }
            if (java == null) {
                String home = System.getProperty(JAVA_HOME_SYS);
                if (home == null) {
                    home = env.get(JAVA_HOME_ENV);
                }
                if (home != null) {
                    java = new File(home);
                }
            }
            nativeImage = Collections.singletonList(NativeImageBuildStep.getNativeImageExecutable(graal, java, env).getAbsolutePath());
        }
        try {
            ArrayList<String> command = new ArrayList<String>(nativeImage);
            if (nativeConfig.cleanupServer) {
                ArrayList<String> cleanup = new ArrayList<String>(nativeImage);
                cleanup.add("--server-shutdown");
                ProcessBuilder pb = new ProcessBuilder(cleanup.toArray(new String[0]));
                pb.directory(outputDir.toFile());
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                Process process = pb.start();
                process.waitFor();
            }
            Boolean enableSslNative = false;
            for (NativeImageSystemPropertyBuildItem prop : nativeImageProperties) {
                if (prop.getKey().equals("quarkus.ssl.native") && prop.getValue() != null) {
                    enableSslNative = Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getKey().equals("quarkus.jni.enable") && prop.getValue() != null) {
                    nativeConfig.enableJni |= Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getKey().equals("quarkus.native.enable-all-security-services") && prop.getValue() != null) {
                    nativeConfig.enableAllSecurityServices |= Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getKey().equals("quarkus.native.enable-all-charsets") && prop.getValue() != null) {
                    nativeConfig.addAllCharsets |= Boolean.parseBoolean(prop.getValue());
                    continue;
                }
                if (prop.getValue() == null) {
                    command.add("-J-D" + prop.getKey());
                    continue;
                }
                command.add("-J-D" + prop.getKey() + "=" + prop.getValue());
            }
            if (enableSslNative.booleanValue()) {
                nativeConfig.enableHttpsUrlHandler = true;
                nativeConfig.enableJni = true;
                nativeConfig.enableAllSecurityServices = true;
            }
            if (nativeConfig.additionalBuildArgs != null) {
                command.addAll(nativeConfig.additionalBuildArgs);
            }
            command.add("--initialize-at-build-time=");
            command.add("-H:InitialCollectionPolicy=com.oracle.svm.core.genscavenge.CollectionPolicy$BySpaceAndTime");
            command.add("-jar");
            command.add(runnerJarName);
            command.add("-J-Djava.util.concurrent.ForkJoinPool.common.parallelism=1");
            if (nativeConfig.enableFallbackImages) {
                command.add("-H:FallbackThreshold=5");
            } else {
                command.add("-H:FallbackThreshold=0");
            }
            if (nativeConfig.reportErrorsAtRuntime) {
                command.add("-H:+ReportUnsupportedElementsAtRuntime");
            }
            if (nativeConfig.reportExceptionStackTraces) {
                command.add("-H:+ReportExceptionStackTraces");
            }
            if (nativeConfig.debugSymbols) {
                command.add("-g");
            }
            if (nativeConfig.debugBuildProcess) {
                command.add("-J-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=y");
            }
            if (nativeConfig.enableReports) {
                command.add("-H:+PrintAnalysisCallTree");
            }
            if (nativeConfig.dumpProxies) {
                command.add("-Dsun.misc.ProxyGenerator.saveGeneratedFiles=true");
                if (nativeConfig.enableServer) {
                    log.warn((Object)"Options dumpProxies and enableServer are both enabled: this will get the proxies dumped in an unknown external working directory");
                }
            }
            if (nativeConfig.nativeImageXmx.isPresent()) {
                command.add("-J-Xmx" + nativeConfig.nativeImageXmx.get());
            }
            ArrayList<String> protocols = new ArrayList<String>(2);
            if (nativeConfig.enableHttpUrlHandler) {
                protocols.add("http");
            }
            if (nativeConfig.enableHttpsUrlHandler) {
                protocols.add("https");
            }
            if (nativeConfig.addAllCharsets) {
                command.add("-H:+AddAllCharsets");
            } else {
                command.add("-H:-AddAllCharsets");
            }
            if (!protocols.isEmpty()) {
                command.add("-H:EnableURLProtocols=" + String.join((CharSequence)",", protocols));
            }
            if (nativeConfig.enableAllSecurityServices) {
                command.add("--enable-all-security-services");
            }
            if (!noPIE.isEmpty()) {
                command.add("-H:NativeLinkerOption=" + noPIE);
            }
            if (nativeConfig.enableRetainedHeapReporting) {
                command.add("-H:+PrintRetainedHeapHistogram");
            }
            if (nativeConfig.enableCodeSizeReporting) {
                command.add("-H:+PrintCodeSizeReport");
            }
            if (!nativeConfig.enableIsolates) {
                command.add("-H:-SpawnIsolates");
            }
            if (nativeConfig.enableJni) {
                command.add("-H:+JNI");
            } else {
                command.add("-H:-JNI");
            }
            if (!nativeConfig.enableServer && !IS_WINDOWS) {
                command.add("--no-server");
            }
            if (nativeConfig.enableVmInspection) {
                command.add("-H:+AllowVMInspection");
            }
            if (nativeConfig.autoServiceLoaderRegistration) {
                command.add("-H:+UseServiceLoaderFeature");
                command.add("-H:+TraceServiceLoaderFeature");
            } else {
                command.add("-H:-UseServiceLoaderFeature");
            }
            if (nativeConfig.fullStackTraces) {
                command.add("-H:+StackTrace");
            } else {
                command.add("-H:-StackTrace");
            }
            String executableName = outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix;
            command.add(executableName);
            log.info((Object)String.join((CharSequence)" ", command));
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            ProcessBuilder pb = new ProcessBuilder(command.toArray(new String[0]));
            pb.directory(outputDir.toFile());
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            Process process = pb.start();
            new Thread(new ErrorReplacingProcessReader(process.getErrorStream(), outputDir.resolve("reports").toFile(), errorReportLatch)).start();
            errorReportLatch.await();
            if (process.waitFor() != 0) {
                throw new RuntimeException("Image generation failed");
            }
            Path generatedImage = outputDir.resolve(executableName);
            IoUtils.copy((Path)generatedImage, (Path)outputTargetBuildItem.getOutputDirectory().resolve(executableName));
            Files.delete(generatedImage);
            String finalPath = outputTargetBuildItem.getBaseName();
            System.setProperty("native.image.path", finalPath);
            return new NativeImageBuildItem(Paths.get(finalPath, new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build native image", e);
        }
    }

    private boolean isThisGraalVMVersionObsolete() {
        String vmName = System.getProperty("java.vm.name");
        log.info((Object)("Running Quarkus native-image plugin on " + vmName));
        List<String> obsoleteGraalVmVersions = Arrays.asList("1.0.0", "19.0.", "19.1.");
        boolean vmVersionIsObsolete = obsoleteGraalVmVersions.stream().anyMatch(vmName::contains);
        if (vmVersionIsObsolete) {
            log.error((Object)"Out of date build of GraalVM detected! Please upgrade to GraalVM 19.2.0.");
            return true;
        }
        return false;
    }

    private static File getNativeImageExecutable(String graalVmHome, File javaHome, Map<String, String> env) {
        File file;
        String imageName;
        String string = imageName = IS_WINDOWS ? "native-image.cmd" : "native-image";
        if (graalVmHome != null && (file = Paths.get(graalVmHome, "bin", imageName).toFile()).exists()) {
            return file;
        }
        if (javaHome != null && (file = new File(javaHome, "bin/" + imageName)).exists()) {
            return file;
        }
        String systemPath = env.get(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file2;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file2 = new File(dir, imageName)).exists()) continue;
                return file2;
            }
        }
        throw new RuntimeException("Cannot find the `" + imageName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`");
    }

    /*
     * Exception decompiling
     */
    private static String getLinuxID(String option) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void safeWaitFor(Process process) {
        boolean intr = false;
        while (true) {
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException ex) {
                intr = true;
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String detectNoPIE() {
        String argument = NativeImageBuildStep.testGCCArgument("-no-pie");
        return argument.length() == 0 ? NativeImageBuildStep.testGCCArgument("-nopie") : argument;
    }

    private static String testGCCArgument(String argument) {
        try {
            Process gcc = new ProcessBuilder("cc", "-v", "-E", argument, "-").start();
            gcc.getOutputStream().close();
            if (gcc.waitFor() == 0) {
                return argument;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }
}

