/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.BooleanConfigType;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.ConfigPatternMap;
import io.quarkus.deployment.configuration.ConfigType;
import io.quarkus.deployment.configuration.DoubleConfigType;
import io.quarkus.deployment.configuration.FloatConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.IntConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.configuration.LongConfigType;
import io.quarkus.deployment.configuration.MapConfigType;
import io.quarkus.deployment.configuration.ObjectConfigType;
import io.quarkus.deployment.configuration.ObjectListConfigType;
import io.quarkus.deployment.configuration.OptionalObjectConfigType;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.annotations.DefaultConverter;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.util.StringUtil;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;

public class ConfigDefinition
extends CompoundConfigType {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");
    public static final String NO_CONTAINING_NAME = "<<ignored>>";
    private static final String QUARKUS_NAMESPACE = "quarkus";
    private static final List<String> FALSE_POSITIVE_QUARKUS_CONFIG_MISSES = Arrays.asList("quarkus.live-reload.password", "quarkus.live-reload.url", "quarkus.debug.generated-classes-dir", "quarkus.debug.reflection", "quarkus.build.skip", "quarkus.version", "quarkus.profile", "quarkus.test.profile", "quarkus.test.native-image-wait-time", "quarkus.test.native-image-profile");
    private final TreeMap<String, Object> rootObjectsByContainingName = new TreeMap();
    private final HashMap<Class<?>, Object> rootObjectsByClass = new HashMap();
    private final ConfigPatternMap<LeafConfigType> leafPatterns = new ConfigPatternMap();
    private final IdentityHashMap<Object, ValueInfo> realizedInstances = new IdentityHashMap();
    private final TreeMap<String, RootInfo> rootTypesByContainingName = new TreeMap();
    private final FieldDescriptor rootField;
    private final TreeMap<String, String> loadedProperties = new TreeMap();
    private final boolean deferResolution;

    public ConfigDefinition(FieldDescriptor rootField, boolean deferResolution) {
        super(null, null, false);
        this.deferResolution = deferResolution;
        Assert.checkNotNullParam((String)"rootField", (Object)rootField);
        this.rootField = rootField;
    }

    public ConfigDefinition(FieldDescriptor rootField) {
        this(rootField, false);
    }

    @Override
    void acceptConfigurationValueIntoLeaf(LeafConfigType leafType, NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        throw Assert.unsupported();
    }

    @Override
    void generateAcceptConfigurationValueIntoLeaf(BytecodeCreator body, LeafConfigType leafType, ResultHandle name, ResultHandle cache, ResultHandle config) {
        throw Assert.unsupported();
    }

    @Override
    Object getChildObject(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Object self, String childName) {
        return this.rootObjectsByContainingName.get(childName);
    }

    @Override
    ResultHandle generateGetChildObject(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config, ResultHandle self, String childName) {
        return body.readInstanceField(this.rootTypesByContainingName.get(childName).getFieldDescriptor(), self);
    }

    @Override
    TreeMap<String, Object> getOrCreate(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        return this.rootObjectsByContainingName;
    }

    @Override
    ResultHandle generateGetOrCreate(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        return body.readStaticField(this.rootField);
    }

    @Override
    void setChildObject(NameIterator name, Object self, String childName, Object value) {
        if (self != this.rootObjectsByContainingName) {
            throw new IllegalStateException("Wrong self pointer: " + self);
        }
        RootInfo rootInfo = this.rootTypesByContainingName.get(childName);
        assert (rootInfo != null) : "Unknown child: " + childName;
        assert (!this.rootObjectsByContainingName.containsKey(childName)) : "Child added twice: " + childName;
        this.rootObjectsByContainingName.put(childName, value);
        this.rootObjectsByClass.put(rootInfo.getRootClass(), value);
        this.realizedInstances.put(value, new ValueInfo(childName, rootInfo));
    }

    @Override
    void generateSetChildObject(BytecodeCreator body, ResultHandle name, ResultHandle self, String containingName, ResultHandle value) {
        throw Assert.unsupported();
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        throw Assert.unsupported();
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        throw Assert.unsupported();
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        throw Assert.unsupported();
    }

    @Override
    public void load() {
        this.loadFrom(this.leafPatterns);
    }

    public void initialize(SmallRyeConfig config, ExpandingConfigSource.Cache cache) {
        for (Map.Entry<String, RootInfo> entry : this.rootTypesByContainingName.entrySet()) {
            RootInfo rootInfo = entry.getValue();
            rootInfo.getRootType().getOrCreate(new NameIterator("ignored", true), cache, config);
        }
    }

    public void registerConfigRoot(Class<?> configRoot) {
        AccessorFinder accessorFinder = new AccessorFinder();
        ConfigRoot configRootAnnotation = configRoot.getAnnotation(ConfigRoot.class);
        ConfigPhase configPhase = configRootAnnotation.phase();
        if (configRoot.isAnnotationPresent(ConfigGroup.class)) {
            throw ConfigDefinition.reportError(configRoot, "Roots cannot have a @ConfigGroup annotation");
        }
        String containingName = configPhase == ConfigPhase.RUN_TIME ? StringUtil.join((Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCaseFirst((Iterator)StringUtil.camelHumpsIterator((String)configRoot.getSimpleName())), (String[])new String[]{"Config", "Configuration", "RunTimeConfig", "RunTimeConfiguration"})) : StringUtil.join((Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCaseFirst((Iterator)StringUtil.camelHumpsIterator((String)configRoot.getSimpleName())), (String[])new String[]{"Config", "Configuration", "BuildTimeConfig", "BuildTimeConfiguration"}));
        String name = configRootAnnotation.name();
        if (name.equals("<<parent>>")) {
            throw ConfigDefinition.reportError(configRoot, "Root cannot inherit parent name because it has no parent");
        }
        String rootName = name.equals("<<element name>>") ? containingName : (name.equals("<<hyphenated element name>>") ? StringUtil.join((String)"-", (Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)configRoot.getSimpleName())), (String[])new String[]{"config", "configuration"})) : name);
        if (this.rootTypesByContainingName.containsKey(containingName)) {
            throw ConfigDefinition.reportError(configRoot, "Duplicate configuration root name \"" + containingName + "\"");
        }
        GroupConfigType configGroup = this.processConfigGroup(containingName, this, true, rootName, configRoot, accessorFinder);
        RootInfo rootInfo = new RootInfo(configRoot, configGroup, FieldDescriptor.of((String)DescriptorUtils.getTypeStringFromDescriptorFormat((String)this.rootField.getType()), (String)containingName, Object.class), configPhase);
        this.rootTypesByContainingName.put(containingName, rootInfo);
    }

    private GroupConfigType processConfigGroup(String containingName, CompoundConfigType container, boolean consumeSegment, String baseKey, Class<?> configGroupClass, AccessorFinder accessorFinder) {
        Field[] fields;
        GroupConfigType gct = new GroupConfigType(containingName, container, consumeSegment, configGroupClass, accessorFinder);
        for (Field field : fields = configGroupClass.getDeclaredFields()) {
            LeafConfigType leaf;
            boolean consume;
            String subKey;
            String name;
            String javadocKey = field.getDeclaringClass().getName().replace("$", ".") + "." + field.getName();
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            ConfigItem configItemAnnotation = field.getAnnotation(ConfigItem.class);
            String string = name = configItemAnnotation == null ? StringUtil.hyphenate((String)field.getName()) : configItemAnnotation.name();
            if (name.equals("<<parent>>")) {
                subKey = baseKey;
                consume = false;
            } else if (name.equals("<<element name>>")) {
                subKey = baseKey + "." + field.getName();
                consume = true;
            } else if (name.equals("<<hyphenated element name>>")) {
                subKey = baseKey + "." + StringUtil.hyphenate((String)field.getName());
                consume = true;
            } else {
                subKey = baseKey + "." + name;
                consume = true;
            }
            String defaultValue = configItemAnnotation == null ? "<<no default>>" : configItemAnnotation.defaultValue();
            Type fieldType = field.getGenericType();
            Class<?> fieldClass = field.getType();
            if (fieldClass.isAnnotationPresent(ConfigGroup.class)) {
                if (!defaultValue.equals("<<no default>>")) {
                    throw ConfigDefinition.reportError(field, "Unsupported default value");
                }
                gct.addField(this.processConfigGroup(field.getName(), gct, consume, subKey, fieldClass, accessorFinder));
                continue;
            }
            if (fieldClass.isPrimitive()) {
                if (fieldClass == Boolean.TYPE) {
                    leaf = new BooleanConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "false" : defaultValue, javadocKey, subKey, this.loadEnhancedConverter(field, Boolean.class, subKey));
                    gct.addField(leaf);
                } else if (fieldClass == Integer.TYPE) {
                    leaf = new IntConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "0" : defaultValue, javadocKey, subKey, this.loadEnhancedConverter(field, Integer.class, subKey));
                    gct.addField(leaf);
                } else if (fieldClass == Long.TYPE) {
                    leaf = new LongConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "0" : defaultValue, javadocKey, subKey, this.loadEnhancedConverter(field, Long.class, subKey));
                    gct.addField(leaf);
                } else if (fieldClass == Double.TYPE) {
                    leaf = new DoubleConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "0" : defaultValue, javadocKey, subKey, this.loadEnhancedConverter(field, Double.class, subKey));
                    gct.addField(leaf);
                } else if (fieldClass == Float.TYPE) {
                    leaf = new FloatConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "0" : defaultValue, javadocKey, subKey, this.loadEnhancedConverter(field, Float.class, subKey));
                    gct.addField(leaf);
                } else {
                    throw ConfigDefinition.reportError(field, "Unsupported primitive field type");
                }
                container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
                continue;
            }
            if (fieldClass == Map.class) {
                if (ReflectUtil.rawTypeOfParameter(fieldType, 0) != String.class) {
                    throw ConfigDefinition.reportError(field, "Map key must be " + String.class);
                }
                Type mapValueType = ReflectUtil.typeOfParameter(fieldType, 1);
                Class<?> mapValueRawType = ReflectUtil.rawTypeOf(mapValueType);
                this.addMapField(field, gct, consume, subKey, mapValueType, accessorFinder, javadocKey, mapValueRawType);
                continue;
            }
            if (fieldClass == List.class) {
                ObjectListConfigType objectListConfigType;
                leaf = objectListConfigType = this.newObjectListConfigType(field, gct, consume, defaultValue, javadocKey, subKey);
                gct.addField(leaf);
                container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
                continue;
            }
            if (fieldClass == Optional.class) {
                OptionalObjectConfigType optionalObjectConfigType = this.newOptionalObjectConfigType(field, gct, consume, defaultValue, javadocKey, subKey);
                leaf = optionalObjectConfigType;
                gct.addField(leaf);
                container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
                continue;
            }
            ObjectConfigType objectConfigType = this.newObjectConfigType(field, gct, consume, defaultValue, javadocKey, subKey);
            leaf = objectConfigType;
            gct.addField(leaf);
            container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
        }
        return gct;
    }

    private <T> void addMapField(Field field, GroupConfigType gct, boolean consume, String subKey, Type mapValueType, AccessorFinder accessorFinder, String javadocKey, Class<T> mapValueRawType) {
        Class<Converter<T>> converterClass = this.loadEnhancedConverter(field, mapValueRawType, subKey);
        gct.addField(this.processMap(field.getName(), gct, field, consume, subKey, mapValueType, accessorFinder, javadocKey, converterClass));
    }

    private <T> ObjectConfigType<T> newObjectConfigType(Field field, GroupConfigType gct, boolean consume, String defaultValue, String javadocKey, String subKey) {
        Class<?> fieldClass = field.getType();
        return new ObjectConfigType(field.getName(), gct, consume, this.mapDefaultValue(defaultValue, fieldClass), fieldClass, javadocKey, subKey, this.loadEnhancedConverter(field, fieldClass, subKey));
    }

    private <T> OptionalObjectConfigType<T> newOptionalObjectConfigType(Field field, GroupConfigType gct, boolean consume, String defaultValue, String javadocKey, String subKey) {
        Class<?> optionalType = ReflectUtil.rawTypeOfParameter(field.getGenericType(), 0);
        return new OptionalObjectConfigType(field.getName(), gct, consume, defaultValue.equals("<<no default>>") ? "" : defaultValue, optionalType, javadocKey, subKey, this.loadEnhancedConverter(field, optionalType, subKey));
    }

    private <T> ObjectListConfigType<T> newObjectListConfigType(Field field, GroupConfigType gct, boolean consume, String defaultValue, String javadocKey, String subKey) {
        Class<?> listType = ReflectUtil.rawTypeOfParameter(field.getGenericType(), 0);
        return new ObjectListConfigType(field.getName(), gct, consume, this.mapDefaultValue(defaultValue, listType), listType, javadocKey, subKey, this.loadEnhancedConverter(field, listType, subKey));
    }

    private <T> Class<? extends Converter<T>> loadEnhancedConverter(Field field, Class<T> clazz, String configProperty) {
        DefaultConverter defaultConverter = field.getAnnotation(DefaultConverter.class);
        ConvertWith convertWith = field.getAnnotation(ConvertWith.class);
        if (defaultConverter != null && convertWith != null) {
            throw new IllegalArgumentException(String.format("Duplicate conversion behaviour specified on property %s : %s annotation and %s annotation given", configProperty, DefaultConverter.class.getName(), ConvertWith.class.getName()));
        }
        if (defaultConverter != null) {
            return null;
        }
        if (convertWith != null) {
            Class converterClass = convertWith.value();
            try {
                Method method = converterClass.getMethod("convert", String.class);
                Type type = method.getAnnotatedReturnType().getType();
                if (clazz.isAssignableFrom(ReflectUtil.rawTypeOf(type))) {
                    return converterClass;
                }
                throw new IllegalArgumentException(String.format("Invalid converter supplied. Cannot convert %s to %s using the given converter %s", configProperty, clazz, converterClass));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (clazz.isEnum()) {
            Class<HyphenateEnumConverter> converterClass = HyphenateEnumConverter.class;
            return converterClass;
        }
        return null;
    }

    private <T> MapConfigType processMap(String containingName, CompoundConfigType container, AnnotatedElement containingElement, boolean consumeSegment, String baseKey, Type mapValueType, AccessorFinder accessorFinder, String javadocKey, Class<? extends Converter<T>> converterClass) {
        MapConfigType mct = new MapConfigType(containingName, container, consumeSegment);
        Class<?> valueClass = ReflectUtil.rawTypeOf(mapValueType);
        String subKey = baseKey + ".{*}";
        if (valueClass == Map.class) {
            if (!(mapValueType instanceof ParameterizedType)) {
                throw ConfigDefinition.reportError(containingElement, "Map must be parameterized");
            }
            this.processMap(NO_CONTAINING_NAME, mct, containingElement, true, subKey, ReflectUtil.typeOfParameter(mapValueType, 1), accessorFinder, javadocKey, converterClass);
        } else if (valueClass.isAnnotationPresent(ConfigGroup.class)) {
            this.processConfigGroup(NO_CONTAINING_NAME, mct, true, subKey, valueClass, accessorFinder);
        } else if (valueClass == List.class) {
            if (!(mapValueType instanceof ParameterizedType)) {
                throw ConfigDefinition.reportError(containingElement, "List must be parameterized");
            }
            Class<?> listType = ReflectUtil.rawTypeOfParameter(mapValueType, 0);
            ObjectListConfigType leaf = new ObjectListConfigType(NO_CONTAINING_NAME, mct, consumeSegment, "", listType, javadocKey, subKey, converterClass);
            container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
        } else {
            if (valueClass == Optional.class || valueClass == OptionalInt.class || valueClass == OptionalDouble.class || valueClass == OptionalLong.class) {
                throw ConfigDefinition.reportError(containingElement, "Optionals are not allowed as a map value type");
            }
            ObjectConfigType leaf = new ObjectConfigType(NO_CONTAINING_NAME, mct, true, "", valueClass, javadocKey, subKey, converterClass);
            container.getConfigDefinition().getLeafPatterns().addPattern(subKey, leaf);
        }
        return mct;
    }

    private String mapDefaultValue(String defaultValue, Class<?> fieldClass) {
        String mappedDefault = defaultValue;
        if (defaultValue.equals("<<no default>>")) {
            mappedDefault = Number.class.isAssignableFrom(fieldClass) ? "0" : "";
        }
        return mappedDefault;
    }

    private static IllegalArgumentException reportError(AnnotatedElement e, String msg) {
        if (e instanceof Member) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Member)((Object)e)).getDeclaringClass());
        }
        if (e instanceof Parameter) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Parameter)e).getDeclaringExecutable() + " of " + ((Parameter)e).getDeclaringExecutable().getDeclaringClass());
        }
        return new IllegalArgumentException(msg + " at " + e);
    }

    public void generateConfigRootClass(ClassOutput classOutput, AccessorFinder accessorFinder) {
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(DescriptorUtils.getTypeStringFromDescriptorFormat((String)this.rootField.getType())).superClass(Object.class).build();
             MethodCreator ctor = cc.getMethodCreator("<init>", Void.TYPE, new Class[]{SmallRyeConfig.class});){
            ctor.setModifiers(1);
            ResultHandle self = ctor.getThis();
            ResultHandle config = ctor.getMethodParam(0);
            ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), self, new ResultHandle[0]);
            ResultHandle cache = ctor.newInstance(ECS_CACHE_CTOR, new ResultHandle[0]);
            for (RootInfo value : this.rootTypesByContainingName.values()) {
                if (!value.getConfigPhase().isAvailableAtRun()) continue;
                GroupConfigType rootType = value.getRootType();
                String containingName = rootType.getContainingName();
                FieldDescriptor fieldDescriptor = ((FieldCreator)cc.getFieldCreator(containingName, Object.class).setModifiers(17)).getFieldDescriptor();
                ctor.writeInstanceField(fieldDescriptor, self, ((ConfigType)rootType).writeInitialization((BytecodeCreator)ctor, accessorFinder, cache, config));
            }
            ctor.returnValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfiguration(ExpandingConfigSource.Cache cache, SmallRyeConfig config, Set<String> unmatched, ConfigDefinition ... definitions) {
        for (ConfigDefinition definition : definitions) {
            definition.initialize(config, cache);
        }
        block4: for (String propertyName : config.getPropertyNames()) {
            NameIterator name = new NameIterator(propertyName);
            if (!name.hasNext()) continue;
            if (name.nextSegmentEquals(QUARKUS_NAMESPACE)) {
                name.next();
                for (ConfigDefinition definition : definitions) {
                    LeafConfigType leafType = definition.leafPatterns.match(name);
                    if (leafType == null) continue;
                    name.goToEnd();
                    String nameString = name.toString();
                    if (definition.deferResolution) {
                        boolean old = ExpandingConfigSource.setExpanding((boolean)false);
                        try {
                            leafType.acceptConfigurationValue(name, cache, config);
                            definition.loadedProperties.put(nameString, config.getOptionalValue(nameString, String.class).orElse(""));
                            continue block4;
                        }
                        finally {
                            ExpandingConfigSource.setExpanding((boolean)old);
                            continue block4;
                        }
                    }
                    leafType.acceptConfigurationValue(name, cache, config);
                    definition.loadedProperties.put(nameString, config.getOptionalValue(nameString, String.class).orElse(""));
                    continue block4;
                }
                for (String entry : FALSE_POSITIVE_QUARKUS_CONFIG_MISSES) {
                    if (!propertyName.equals(entry)) continue;
                    continue block4;
                }
                log.warnf("Unrecognized configuration key \"%s\" provided", (Object)propertyName);
                continue;
            }
            unmatched.add(propertyName);
        }
    }

    public ConfigPatternMap<LeafConfigType> getLeafPatterns() {
        return this.leafPatterns;
    }

    @Override
    public ConfigDefinition getConfigDefinition() {
        return this;
    }

    public TreeMap<String, String> getLoadedProperties() {
        return this.loadedProperties;
    }

    private void loadFrom(ConfigPatternMap<LeafConfigType> map) {
        LeafConfigType matched = map.getMatched();
        if (matched != null) {
            matched.load();
        }
        for (String name : map.childNames()) {
            this.loadFrom(map.getChild(name));
        }
    }

    public Object getRealizedInstance(Class<?> rootClass) {
        Object obj = this.rootObjectsByClass.get(rootClass);
        if (obj == null) {
            throw new IllegalArgumentException("Unknown root class: " + rootClass);
        }
        return obj;
    }

    public RootInfo getInstanceInfo(Object obj) {
        ValueInfo valueInfo = this.realizedInstances.get(obj);
        if (valueInfo == null) {
            return null;
        }
        return valueInfo.getRootInfo();
    }

    static final class ValueInfo {
        private final String key;
        private final RootInfo rootInfo;

        ValueInfo(String key, RootInfo rootInfo) {
            this.key = key;
            this.rootInfo = rootInfo;
        }

        String getKey() {
            return this.key;
        }

        RootInfo getRootInfo() {
            return this.rootInfo;
        }
    }

    public static final class RootInfo {
        private final Class<?> rootClass;
        private final GroupConfigType rootType;
        private final FieldDescriptor fieldDescriptor;
        private final ConfigPhase configPhase;

        RootInfo(Class<?> rootClass, GroupConfigType rootType, FieldDescriptor fieldDescriptor, ConfigPhase configPhase) {
            this.rootClass = rootClass;
            this.rootType = rootType;
            this.fieldDescriptor = fieldDescriptor;
            this.configPhase = configPhase;
        }

        public Class<?> getRootClass() {
            return this.rootClass;
        }

        public GroupConfigType getRootType() {
            return this.rootType;
        }

        public FieldDescriptor getFieldDescriptor() {
            return this.fieldDescriptor;
        }

        public ConfigPhase getConfigPhase() {
            return this.configPhase;
        }
    }
}

