/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.CompilerFlags;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JavaCompilationProvider
implements CompilationProvider {
    private static final Set<String> COMPILER_OPTIONS = new HashSet<String>(Arrays.asList("-g", "-parameters"));
    JavaCompiler compiler;
    StandardJavaFileManager fileManager;
    DiagnosticCollector<JavaFileObject> fileManagerDiagnostics;

    @Override
    public Set<String> handledExtensions() {
        return Collections.singleton(".java");
    }

    @Override
    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        JavaCompiler compiler = this.compiler;
        if (compiler == null) {
            compiler = this.compiler = ToolProvider.getSystemJavaCompiler();
        }
        if (compiler == null) {
            throw new RuntimeException("No system java compiler provided");
        }
        try {
            if (this.fileManager == null) {
                this.fileManagerDiagnostics = new DiagnosticCollector();
                this.fileManager = compiler.getStandardFileManager(this.fileManagerDiagnostics, null, context.getSourceEncoding());
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            this.fileManager.setLocation(StandardLocation.CLASS_PATH, context.getClasspath());
            this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(context.getOutputDirectory()));
            CompilerFlags compilerFlags = new CompilerFlags(COMPILER_OPTIONS, context.getCompilerOptions(), context.getSourceJavaVersion(), context.getTargetJvmVersion());
            Iterable<? extends JavaFileObject> sources = this.fileManager.getJavaFileObjectsFromFiles(filesToCompile);
            JavaCompiler.CompilationTask task = compiler.getTask(null, this.fileManager, diagnostics, compilerFlags.toList(), null, sources);
            if (!task.call().booleanValue()) {
                throw new RuntimeException("Compilation failed" + diagnostics.getDiagnostics());
            }
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                System.out.format("%s, line %d in %s", diagnostic.getMessage(null), diagnostic.getLineNumber(), diagnostic.getSource() == null ? "[unknown source]" : ((JavaFileObject)diagnostic.getSource()).getName());
            }
            if (!this.fileManagerDiagnostics.getDiagnostics().isEmpty()) {
                for (Diagnostic<Object> diagnostic : this.fileManagerDiagnostics.getDiagnostics()) {
                    System.out.format("%s, line %d in %s", diagnostic.getMessage(null), diagnostic.getLineNumber(), diagnostic.getSource() == null ? "[unknown source]" : ((JavaFileObject)diagnostic.getSource()).getName());
                }
                this.fileManager.close();
                this.fileManagerDiagnostics = null;
                this.fileManager = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close file manager", e);
        }
    }

    @Override
    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        Path sourceFilePath = null;
        RuntimeUpdatesClassVisitor visitor = new RuntimeUpdatesClassVisitor(sourcePaths, classesPath);
        try (InputStream inputStream = Files.newInputStream(classFilePath, new OpenOption[0]);){
            ClassReader reader = new ClassReader(inputStream);
            reader.accept((ClassVisitor)visitor, 0);
            sourceFilePath = visitor.getSourceFileForClass(classFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sourceFilePath;
    }

    @Override
    public void close() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.close();
            this.fileManager = null;
            this.fileManagerDiagnostics = null;
        }
    }

    static class RuntimeUpdatesClassVisitor
    extends ClassVisitor {
        private Set<String> sourcePaths;
        private String classesPath;
        private String sourceFile;

        public RuntimeUpdatesClassVisitor(Set<String> sourcePaths, String classesPath) {
            super(589824);
            this.sourcePaths = sourcePaths;
            this.classesPath = classesPath;
        }

        public void visitSource(String source, String debug) {
            this.sourceFile = source;
        }

        public Path getSourceFileForClass(Path classFilePath) {
            for (String moduleSourcePath : this.sourcePaths) {
                Path sourcesDir = Paths.get(moduleSourcePath, new String[0]);
                Path classesDir = Paths.get(this.classesPath, new String[0]);
                StringBuilder sourceRelativeDir = new StringBuilder();
                sourceRelativeDir.append(classesDir.relativize(classFilePath.getParent()));
                sourceRelativeDir.append(File.separator);
                sourceRelativeDir.append(this.sourceFile);
                Path sourceFilePath = sourcesDir.resolve(Paths.get(sourceRelativeDir.toString(), new String[0]));
                if (!Files.exists(sourceFilePath, new LinkOption[0])) continue;
                return sourceFilePath;
            }
            return null;
        }
    }
}

