/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.index.ConstPoolScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassTransformingBuildStep {
    private static final Logger log = Logger.getLogger(ClassTransformingBuildStep.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    TransformedClassesBuildItem handleClassTransformation(List<BytecodeTransformerBuildItem> bytecodeTransformerBuildItems, ApplicationArchivesBuildItem appArchives) throws ExecutionException, InterruptedException {
        if (bytecodeTransformerBuildItems.isEmpty()) {
            return new TransformedClassesBuildItem(Collections.emptyMap());
        }
        HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
        final HashSet<String> noConstScanning = new HashSet<String>();
        final HashMap<String, Set> constScanning = new HashMap<String, Set>();
        final HashSet<String> eager = new HashSet<String>();
        for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
            bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i.getVisitorFunction());
            if (i.getRequireConstPoolEntry() == null || i.getRequireConstPoolEntry().isEmpty()) {
                noConstScanning.add(i.getClassToTransform());
            } else {
                constScanning.computeIfAbsent(i.getClassToTransform(), s -> new HashSet()).addAll(i.getRequireConstPoolEntry());
            }
            if (!i.isEager()) continue;
            eager.add(i.getClassToTransform());
        }
        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        ConcurrentHashMap<String, Path> transformedToArchive = new ConcurrentHashMap<String, Path>();
        ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>> transformed = new ConcurrentLinkedDeque<Future<TransformedClassesBuildItem.TransformedClass>>();
        try {
            final ClassLoader transformCl = Thread.currentThread().getContextClassLoader();
            for (Map.Entry entry : bytecodeTransformers.entrySet()) {
                final String className = (String)entry.getKey();
                final String classFileName = className.replace(".", "/") + ".class";
                List archives = cl.getElementsWithResource(classFileName);
                if (!archives.isEmpty()) {
                    final ClassPathElement classPathElement = (ClassPathElement)archives.get(0);
                    Path jar = classPathElement.getRoot();
                    if (jar == null) {
                        log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
                        continue;
                    }
                    final List visitors = (List)entry.getValue();
                    transformedToArchive.put(classFileName, jar);
                    transformed.add(executorPool.submit(new Callable<TransformedClassesBuildItem.TransformedClass>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public TransformedClassesBuildItem.TransformedClass call() throws Exception {
                            ClassLoader old = Thread.currentThread().getContextClassLoader();
                            try {
                                QuarkusClassWriter writer;
                                Thread.currentThread().setContextClassLoader(transformCl);
                                byte[] classData = classPathElement.getResource(classFileName).getData();
                                Set constValues = (Set)constScanning.get(className);
                                if (constValues != null && !noConstScanning.contains(className) && !ConstPoolScanner.constPoolEntryPresent(classData, constValues)) {
                                    TransformedClassesBuildItem.TransformedClass transformedClass = null;
                                    return transformedClass;
                                }
                                ClassReader cr = new ClassReader(classData);
                                QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
                                for (BiFunction i : visitors) {
                                    visitor = (ClassVisitor)i.apply(className, visitor);
                                }
                                cr.accept((ClassVisitor)visitor, 0);
                                byte[] data = writer.toByteArray();
                                if (BootstrapDebug.DEBUG_TRANSFORMED_CLASSES_DIR != null) {
                                    File debugPath = new File(BootstrapDebug.DEBUG_TRANSFORMED_CLASSES_DIR);
                                    if (!debugPath.exists()) {
                                        debugPath.mkdir();
                                    }
                                    File classFile = new File(debugPath, className.replace(".", "/") + ".class");
                                    classFile.getParentFile().mkdirs();
                                    try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                                        classWriter.write(data);
                                    }
                                    catch (Exception e) {
                                        log.errorf((Throwable)e, "Failed to write transformed class %s", (Object)className);
                                    }
                                    log.infof("Wrote transformed class to %s", (Object)classFile.getAbsolutePath());
                                }
                                TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(className, data, classFileName, eager.contains(className));
                                return transformedClass;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                        }
                    }));
                    continue;
                }
                log.warnf("Cannot transform %s as its containing application archive could not be found.", entry.getKey());
            }
        }
        finally {
            executorPool.shutdown();
        }
        HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar = new HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>>();
        if (!transformed.isEmpty()) {
            for (Future future : transformed) {
                TransformedClassesBuildItem.TransformedClass res = (TransformedClassesBuildItem.TransformedClass)future.get();
                if (res == null) continue;
                transformedClassesByJar.computeIfAbsent((Path)transformedToArchive.get(res.getFileName()), (Function<Path, Set<TransformedClassesBuildItem.TransformedClass>>)((Function<Path, Set>)a -> new HashSet())).add(res);
            }
        }
        return new TransformedClassesBuildItem(transformedClassesByJar);
    }
}

