/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class IndexingUtil {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.index");
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final int REQUIRED_INDEX_VERSION = 8;

    public static Index indexJar(Path path) throws IOException {
        return IndexingUtil.indexJar(path.toFile());
    }

    public static Index indexJar(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            ZipEntry existing = jarFile.getEntry(JANDEX_INDEX);
            if (existing != null) {
                Index index;
                try (InputStream in = jarFile.getInputStream(existing);){
                    IndexReader reader = new IndexReader(in);
                    if (reader.getIndexVersion() < 8) {
                        log.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)file);
                        Index index2 = IndexingUtil.indexJar(jarFile);
                        return index2;
                    }
                    index = reader.read();
                }
                return index;
            }
            Index index = IndexingUtil.indexJar(jarFile);
            return index;
        }
    }

    private static Index indexJar(JarFile file) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream inputStream = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                indexer.index(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    public static void indexClass(String beanClass, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader) {
        ClassInfo beanInfo;
        block31: {
            DotName beanClassName = DotName.createSimple((String)beanClass);
            if (additionalIndex.contains(beanClassName)) {
                return;
            }
            beanInfo = quarkusIndex.getClassByName(beanClassName);
            if (beanInfo == null) {
                log.debugf("Index bean class: %s", (Object)beanClass);
                try (InputStream stream = IoUtil.readClass(classLoader, beanClass);){
                    beanInfo = indexer.index(stream);
                    additionalIndex.add(beanInfo.name());
                    break block31;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + beanClass, e);
                }
            }
            additionalIndex.add(beanClassName);
        }
        for (DotName annotationName : beanInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                Throwable throwable = null;
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (annotationStream == null) continue;
                    if (throwable != null) {
                        try {
                            annotationStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + beanClass, e);
            }
        }
        if (beanInfo.superName() != null && !beanInfo.superName().equals((Object)OBJECT)) {
            IndexingUtil.indexClass(beanInfo.superName().toString(), indexer, quarkusIndex, additionalIndex, classLoader);
        }
    }

    public static void indexClass(String beanClass, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader, byte[] beanData) {
        ClassInfo beanInfo;
        block29: {
            DotName beanClassName = DotName.createSimple((String)beanClass);
            if (additionalIndex.contains(beanClassName)) {
                return;
            }
            beanInfo = quarkusIndex.getClassByName(beanClassName);
            if (beanInfo == null) {
                log.debugf("Index bean class: %s", (Object)beanClass);
                try (ByteArrayInputStream stream = new ByteArrayInputStream(beanData);){
                    beanInfo = indexer.index((InputStream)stream);
                    additionalIndex.add(beanInfo.name());
                    break block29;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + beanClass, e);
                }
            }
            additionalIndex.add(beanClassName);
        }
        for (DotName annotationName : beanInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                Throwable throwable = null;
                try {
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (annotationStream == null) continue;
                    if (throwable != null) {
                        try {
                            annotationStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + beanClass, e);
            }
        }
    }
}

