/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import io.quarkus.deployment.util.FileUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class NativeImageBuildLocalContainerRunner
extends NativeImageBuildContainerRunner {
    public NativeImageBuildLocalContainerRunner(NativeConfig nativeConfig, Path outputDir) {
        super(nativeConfig, outputDir);
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs() {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs();
        String volumeOutputPath = this.outputPath;
        if (SystemUtils.IS_OS_WINDOWS) {
            volumeOutputPath = FileUtil.translateToVolumePath(volumeOutputPath);
        } else if (SystemUtils.IS_OS_LINUX) {
            String uid = LinuxIDUtil.getLinuxID("-ur");
            String gid = LinuxIDUtil.getLinuxID("-gr");
            if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                Collections.addAll(containerRuntimeArgs, "--user", uid + ":" + gid);
                if (this.containerRuntime == NativeConfig.ContainerRuntime.PODMAN) {
                    containerRuntimeArgs.add("--userns=keep-id");
                }
            }
        }
        Collections.addAll(containerRuntimeArgs, "--rm", "-v", volumeOutputPath + ":" + "/project" + ":z");
        return containerRuntimeArgs;
    }
}

