/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.ide;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.deployment.ide.IdeConfig;
import io.quarkus.deployment.ide.IdeFileBuildItem;
import io.quarkus.deployment.ide.IdeRunningProcessBuildItem;
import io.quarkus.deployment.ide.IdeUtil;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.runtime.util.JavaVersionUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class IdeProcessor {
    private static final Logger log = Logger.getLogger(IdeProcessor.class);
    private static Map<String, List<Ide>> IDE_MARKER_FILES = new HashMap<String, List<Ide>>();
    private static Map<Predicate<ProcessInfo>, Ide> IDE_PROCESSES = new HashMap<Predicate<ProcessInfo>, Ide>();
    private static Map<Ide, Function<ProcessInfo, String>> IDE_ARGUMENTS_EXEC_INDICATOR = new HashMap<Ide, Function<ProcessInfo, String>>();

    @BuildStep
    public EffectiveIdeBuildItem effectiveIde(LaunchModeBuildItem launchModeBuildItem, IdeConfig ideConfig, IdeFileBuildItem ideFile, IdeRunningProcessBuildItem ideRunningProcess) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        Ide result = null;
        if (ideConfig.target == IdeConfig.Target.auto) {
            if (ideFile.getDetectedIDEs().size() == 1) {
                result = ideFile.getDetectedIDEs().iterator().next();
            } else {
                Set<Ide> runningIdes = ideRunningProcess.getDetectedIDEs();
                if (runningIdes.size() == 1) {
                    result = runningIdes.iterator().next();
                } else {
                    ArrayList<Ide> matches = new ArrayList<Ide>();
                    for (Ide file : ideFile.getDetectedIDEs()) {
                        for (Ide process : runningIdes) {
                            if (file != process) continue;
                            matches.add(file);
                        }
                    }
                    if (matches.size() == 1) {
                        result = (Ide)((Object)matches.get(0));
                    }
                }
            }
        } else if (ideConfig.target == IdeConfig.Target.idea) {
            result = Ide.IDEA;
        } else if (ideConfig.target == IdeConfig.Target.eclipse) {
            result = Ide.ECLIPSE;
        } else if (ideConfig.target == IdeConfig.Target.vscode) {
            result = Ide.VSCODE;
        } else if (ideConfig.target == IdeConfig.Target.netbeans) {
            result = Ide.NETBEANS;
        }
        if (result == null) {
            return null;
        }
        return new EffectiveIdeBuildItem(result);
    }

    @BuildStep
    public IdeFileBuildItem detectIdeFiles(LaunchModeBuildItem launchModeBuildItem, BuildSystemTargetBuildItem buildSystemTarget) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        HashSet<Ide> result = new HashSet<Ide>(2);
        Path projectRoot = buildSystemTarget.getOutputDirectory().getParent();
        IDE_MARKER_FILES.forEach((file, ides) -> {
            if (Files.exists(projectRoot.resolve((String)file), new LinkOption[0])) {
                result.addAll((Collection<Ide>)ides);
            }
        });
        return new IdeFileBuildItem(result);
    }

    @BuildStep
    public IdeRunningProcessBuildItem detectRunningIdeProcesses(LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        HashSet<Ide> result = new HashSet<Ide>(4);
        List<Object> processInfos = Collections.emptyList();
        try {
            processInfos = ProcessUtil.runningProcesses();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        block2: for (ProcessInfo processInfo : processInfos) {
            for (Map.Entry<Predicate<ProcessInfo>, Ide> entry : IDE_PROCESSES.entrySet()) {
                Function<ProcessInfo, String> execIndicator;
                String machineSpecificCommand;
                if (!entry.getKey().test(processInfo)) continue;
                Ide ide = entry.getValue();
                if (IDE_ARGUMENTS_EXEC_INDICATOR.containsKey((Object)ide) && (machineSpecificCommand = (execIndicator = IDE_ARGUMENTS_EXEC_INDICATOR.get((Object)ide)).apply(processInfo)) != null) {
                    ide.setMachineSpecificCommand(machineSpecificCommand);
                }
                result.add(ide);
                continue block2;
            }
        }
        return new IdeRunningProcessBuildItem(result);
    }

    static {
        IDE_MARKER_FILES.put(".idea", Collections.singletonList(Ide.IDEA));
        IDE_MARKER_FILES.put(".project", Arrays.asList(Ide.VSCODE, Ide.ECLIPSE));
        IDE_MARKER_FILES.put("nbactions.xml", Collections.singletonList(Ide.NETBEANS));
        IDE_MARKER_FILES.put("nb-configuration.xml", Collections.singletonList(Ide.NETBEANS));
        IDE_MARKER_FILES = Collections.unmodifiableMap(IDE_MARKER_FILES);
        IDE_PROCESSES.put(processInfo -> ((ProcessInfo)processInfo).containInCommand("idea") && ((ProcessInfo)processInfo).command.endsWith("java"), Ide.IDEA);
        IDE_PROCESSES.put(processInfo -> ((ProcessInfo)processInfo).containInCommand("code"), Ide.VSCODE);
        IDE_PROCESSES.put(processInfo -> ((ProcessInfo)processInfo).containInCommand("eclipse"), Ide.ECLIPSE);
        IDE_PROCESSES.put(processInfo -> ((ProcessInfo)processInfo).containInArguments("netbeans"), Ide.NETBEANS);
        IDE_ARGUMENTS_EXEC_INDICATOR.put(Ide.NETBEANS, processInfo -> {
            String platform = ((ProcessInfo)processInfo).getArgumentThatContains("nbexec");
            if (platform != null && !platform.isEmpty()) {
                platform = platform.substring(0, platform.indexOf("platform")).concat("bin").concat(File.separator);
                platform = IdeUtil.isWindows() ? platform.concat("netbeans.exe") : platform.concat("netbeans");
                return platform;
            }
            return null;
        });
        IDE_ARGUMENTS_EXEC_INDICATOR.put(Ide.IDEA, processInfo -> {
            String command = processInfo.getCommand();
            int jbrIndex = command.indexOf("jbr");
            if (jbrIndex > -1 && command.endsWith("java")) {
                String ideaHome = command.substring(0, jbrIndex);
                return ideaHome + "bin" + File.separator + "idea" + (IdeUtil.isWindows() ? ".exe" : ".sh");
            }
            return null;
        });
        IDE_PROCESSES = Collections.unmodifiableMap(IDE_PROCESSES);
    }

    private static class ProcessInfo {
        private final String command;
        private final String[] arguments;

        public ProcessInfo(String command, String[] arguments) {
            this.command = command;
            this.arguments = arguments;
        }

        public String getCommand() {
            return this.command;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        private boolean containInCommand(String value) {
            return this.command.contains(value);
        }

        private boolean containInArguments(String value) {
            if (this.arguments != null) {
                for (String argument : this.arguments) {
                    if (!argument.contains(value)) continue;
                    return true;
                }
            }
            return false;
        }

        private String getArgumentThatContains(String contain) {
            if (this.arguments != null) {
                for (String argument : this.arguments) {
                    if (!argument.contains(contain)) continue;
                    return argument;
                }
            }
            return null;
        }
    }

    private static class ProcessUtil {
        private ProcessUtil() {
        }

        public static List<ProcessInfo> runningProcesses() {
            if (!JavaVersionUtil.isJava11OrHigher()) {
                return Collections.emptyList();
            }
            try {
                Class<?> processHandlerClass = Class.forName("java.lang.ProcessHandle");
                Method allProcessesMethod = processHandlerClass.getMethod("allProcesses", new Class[0]);
                Method processHandleInfoMethod = processHandlerClass.getMethod("info", new Class[0]);
                Class<?> processHandleInfoClass = Class.forName("java.lang.ProcessHandle$Info");
                Method processHandleInfoCommandMethod = processHandleInfoClass.getMethod("command", new Class[0]);
                Method processHandleInfoArgumentsMethod = processHandleInfoClass.getMethod("arguments", new Class[0]);
                Stream allProcessesResult = (Stream)allProcessesMethod.invoke(null, new Object[0]);
                ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
                allProcessesResult.forEach(o -> {
                    try {
                        Object processHandleInfo = processHandleInfoMethod.invoke(o, new Object[0]);
                        Optional command = (Optional)processHandleInfoCommandMethod.invoke(processHandleInfo, new Object[0]);
                        if (command.isPresent()) {
                            Optional arguments = (Optional)processHandleInfoArgumentsMethod.invoke(processHandleInfo, new Object[0]);
                            result.add(new ProcessInfo((String)command.get(), arguments.orElse(null)));
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to determine running IDE processes", e);
            }
        }
    }
}

