/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class ReflectiveHierarchyBuildItem
extends MultiBuildItem {
    private final Type type;
    private IndexView index;
    private Predicate<DotName> ignorePredicate;

    public ReflectiveHierarchyBuildItem(Type type) {
        this(type, DefaultIgnorePredicate.INSTANCE);
    }

    public ReflectiveHierarchyBuildItem(Type type, IndexView index) {
        this(type, index, DefaultIgnorePredicate.INSTANCE);
    }

    public ReflectiveHierarchyBuildItem(Type type, Predicate<DotName> ignorePredicate) {
        this.type = type;
        this.ignorePredicate = ignorePredicate;
    }

    public ReflectiveHierarchyBuildItem(Type type, IndexView index, Predicate<DotName> ignorePredicate) {
        this.type = type;
        this.index = index;
        this.ignorePredicate = ignorePredicate;
    }

    public Type getType() {
        return this.type;
    }

    public IndexView getIndex() {
        return this.index;
    }

    public Predicate<DotName> getIgnorePredicate() {
        return this.ignorePredicate;
    }

    private static class DefaultIgnorePredicate
    implements Predicate<DotName> {
        private static final DefaultIgnorePredicate INSTANCE = new DefaultIgnorePredicate();
        private static final List<String> DEFAULT_IGNORED_PACKAGES = Arrays.asList("java.", "io.reactivex.", "org.reactivestreams.");

        private DefaultIgnorePredicate() {
        }

        @Override
        public boolean test(DotName name) {
            return this.isInContainerPackage(name.toString());
        }

        private boolean isInContainerPackage(String name) {
            for (String containerPackageName : DEFAULT_IGNORED_PACKAGES) {
                if (!name.startsWith(containerPackageName)) continue;
                return true;
            }
            return false;
        }
    }
}

