/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.runner.bootstrap.RunningQuarkusApplicationImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class StartupActionImpl
implements StartupAction {
    private static final Logger log = Logger.getLogger(StartupActionImpl.class);
    static final String DEBUG_CLASSES_DIR = System.getProperty("quarkus.debug.generated-classes-dir");
    private final CuratedApplication curatedApplication;
    private final BuildResult buildResult;

    public StartupActionImpl(CuratedApplication curatedApplication, BuildResult buildResult) {
        this.curatedApplication = curatedApplication;
        this.buildResult = buildResult;
    }

    public RunningQuarkusApplication run(String ... args) throws Exception {
        QuarkusClassLoader runtimeClassLoader;
        Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = this.extractTransformers();
        QuarkusClassLoader baseClassLoader = this.curatedApplication.getBaseRuntimeClassLoader();
        ClassLoader transformerClassLoader = ((DeploymentClassLoaderBuildItem)this.buildResult.consume(DeploymentClassLoaderBuildItem.class)).getClassLoader();
        if (this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.DEV) {
            baseClassLoader.reset(this.extractGeneratedResources(false), bytecodeTransformers, transformerClassLoader);
            runtimeClassLoader = this.curatedApplication.createRuntimeClassLoader(baseClassLoader, bytecodeTransformers, transformerClassLoader, this.extractGeneratedResources(true));
        } else {
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            resources.putAll(this.extractGeneratedResources(false));
            resources.putAll(this.extractGeneratedResources(true));
            baseClassLoader.reset(resources, bytecodeTransformers, transformerClassLoader);
            runtimeClassLoader = baseClassLoader;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> appClass;
            Thread.currentThread().setContextClassLoader((ClassLoader)runtimeClassLoader);
            String className = ((ApplicationClassNameBuildItem)this.buildResult.consume(ApplicationClassNameBuildItem.class)).getClassName();
            try {
                appClass = Class.forName(className, true, (ClassLoader)runtimeClassLoader);
            }
            catch (Throwable t) {
                try {
                    Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)runtimeClassLoader);
                    configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_BOOTSTRAP_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
            Method start = appClass.getMethod("start", String[].class);
            Object application = appClass.newInstance();
            start.invoke(application, new Object[]{args});
            final Closeable closeTask = (Closeable)application;
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        try {
                            closeTask.close();
                        }
                        finally {
                            runtimeClassLoader.close();
                        }
                    }
                    finally {
                        if (StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, (ClassLoader)runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException("Failed to start Quarkus", e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> extractTransformers() {
        HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = new HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>>();
        List transformers = this.buildResult.consumeMulti(BytecodeTransformerBuildItem.class);
        for (BytecodeTransformerBuildItem i : transformers) {
            ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>> list = (ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>>)bytecodeTransformers.get(i.getClassToTransform());
            if (list == null) {
                list = new ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>>();
                bytecodeTransformers.put(i.getClassToTransform(), list);
            }
            list.add(i.getVisitorFunction());
        }
        return bytecodeTransformers;
    }

    private Map<String, byte[]> extractGeneratedResources(boolean applicationClasses) {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
            if (i.isApplicationClass() != applicationClasses) continue;
            data.put(i.getName().replace(".", "/") + ".class", i.getClassData());
            if (DEBUG_CLASSES_DIR == null) continue;
            try {
                File debugPath = new File(DEBUG_CLASSES_DIR);
                if (!debugPath.exists()) {
                    debugPath.mkdir();
                }
                File classFile = new File(debugPath, i.getName() + ".class");
                classFile.getParentFile().mkdirs();
                try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                    classWriter.write(i.getClassData());
                }
                log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
            }
            catch (Exception t) {
                log.errorf((Throwable)t, "Failed to write debug class files %s", (Object)i.getName());
            }
        }
        if (applicationClasses) {
            for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                data.put(i.getName(), i.getClassData());
            }
        }
        return data;
    }
}

