/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.banner.BannerConfig;
import io.quarkus.builder.Version;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConsoleFormatterBannerBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.BannerRecorder;
import io.quarkus.runtime.BannerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;

public class BannerProcessor {
    private static final Logger logger = Logger.getLogger(BannerProcessor.class);

    @BuildStep(loadsApplicationClasses=true, onlyIfNot={IsTest.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ConsoleFormatterBannerBuildItem recordBanner(BannerRecorder recorder, BannerConfig config, BannerRuntimeConfig bannerRuntimeConfig) {
        String bannerText = this.readBannerFile(config);
        return new ConsoleFormatterBannerBuildItem((RuntimeValue<Optional<Supplier<String>>>)recorder.provideBannerSupplier(bannerText, bannerRuntimeConfig));
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchBannerChanges(BannerConfig config) {
        return new HotDeploymentWatchedFileBuildItem(config.path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readBannerFile(BannerConfig config) {
        try {
            Map.Entry<URL, Boolean> entry = this.getBanner(config);
            URL bannerResourceURL = entry.getKey();
            if (bannerResourceURL == null) {
                logger.warn((Object)"Could not locate banner file");
                return "";
            }
            try (InputStream is = bannerResourceURL.openStream();){
                byte[] content = FileUtil.readFileContents(is);
                String bannerTitle = new String(content, StandardCharsets.UTF_8);
                int width = 0;
                Scanner scanner = new Scanner(bannerTitle);
                while (scanner.hasNextLine()) {
                    width = Math.max(width, scanner.nextLine().length());
                }
                String tagline = "\n";
                Boolean isDefaultBanner = entry.getValue();
                if (!isDefaultBanner.booleanValue()) {
                    tagline = String.format("\n%" + width + "s\n", "Powered by Quarkus " + Version.getVersion());
                }
                String string = bannerTitle + tagline;
                return string;
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to read banner file");
            return "";
        }
    }

    private Map.Entry<URL, Boolean> getBanner(BannerConfig config) throws IOException {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(config.path);
        URL defaultBanner = null;
        URL selectedBanner = null;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (defaultBanner == null && this.isQuarkusCoreBanner(url)) {
                defaultBanner = url;
            }
            if (selectedBanner != null) continue;
            selectedBanner = url;
        }
        return new AbstractMap.SimpleEntry<Object, Boolean>(selectedBanner, defaultBanner == selectedBanner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isQuarkusCoreBanner(URL url) throws IOException {
        if (!"jar".equals(url.getProtocol())) {
            return false;
        }
        String thisClassName = this.getClass().getName();
        String jarPath = url.getPath().substring(0, url.getPath().lastIndexOf(33));
        try (JarFile jarFile = new JarFile(Paths.get(new URI(jarPath)).toFile());){
            boolean bl = jarFile.getJarEntry(thisClassName.replace('.', '/') + ".class") != null;
            return bl;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

