/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

public final class ArchiveRootBuildItem
extends SimpleBuildItem {
    private final Path archiveLocation;
    private final Path archiveRoot;
    private final Collection<Path> excludedFromIndexing;

    public ArchiveRootBuildItem(Path appClassesDir) {
        this(appClassesDir, appClassesDir);
    }

    public ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot) {
        this(archiveLocation, archiveRoot, Collections.emptySet());
    }

    public ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot, Collection<Path> excludedFromIndexing) {
        this.archiveLocation = archiveLocation;
        if (!Files.isDirectory(archiveRoot, new LinkOption[0])) {
            throw new IllegalArgumentException(archiveRoot + " does not point to the application classes directory");
        }
        this.archiveRoot = archiveRoot;
        this.excludedFromIndexing = excludedFromIndexing;
    }

    public Path getArchiveLocation() {
        return this.archiveLocation;
    }

    public Path getArchiveRoot() {
        return this.archiveRoot;
    }

    public boolean isExcludedFromIndexing(Path p) {
        return this.excludedFromIndexing.contains(p);
    }
}

