/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigGenerationBuildStep {
    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, List<ConfigurationTypeBuildItem> typeItems, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (RunTimeConfigurationDefaultBuildItem item : runTimeDefaults) {
            if (defaults.putIfAbsent(item.getKey(), item.getValue()) == null) continue;
            throw new IllegalStateException("More than one default value for " + item.getKey() + " was produced");
        }
        List<Class<?>> additionalConfigTypes = typeItems.stream().map(ConfigurationTypeBuildItem::getValueType).collect(Collectors.toList());
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        RunTimeConfigurationGenerator.generate(readResult, classOutput, defaults, additionalConfigTypes);
    }
}

