/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import java.io.Closeable;
import java.nio.file.Path;
import org.jboss.jandex.IndexView;

public final class ApplicationArchiveImpl
extends MultiBuildItem
implements ApplicationArchive {
    private final IndexView indexView;
    private final PathsCollection rootDirs;
    private final boolean jar;
    private final PathsCollection paths;

    public ApplicationArchiveImpl(IndexView indexView, Path archiveRoot, Closeable closeable, boolean jar, Path archiveLocation) {
        this.indexView = indexView;
        this.rootDirs = PathsCollection.of((Path[])new Path[]{archiveRoot});
        this.jar = jar;
        this.paths = PathsCollection.of((Path[])new Path[]{archiveLocation});
    }

    public ApplicationArchiveImpl(IndexView indexView, PathsCollection rootDirs, PathsCollection paths) {
        this.indexView = indexView;
        this.rootDirs = rootDirs;
        this.paths = paths;
        this.jar = false;
    }

    @Override
    public IndexView getIndex() {
        return this.indexView;
    }

    @Override
    @Deprecated
    public Path getArchiveRoot() {
        return (Path)this.rootDirs.iterator().next();
    }

    @Override
    @Deprecated
    public boolean isJarArchive() {
        return this.jar;
    }

    @Override
    @Deprecated
    public Path getArchiveLocation() {
        return (Path)this.paths.iterator().next();
    }

    @Override
    public PathsCollection getRootDirs() {
        return this.rootDirs;
    }

    @Override
    public PathsCollection getPaths() {
        return this.paths;
    }
}

