/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassTransformingBuildStep {
    private static final Logger log = Logger.getLogger(ClassTransformingBuildStep.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    TransformedClassesBuildItem handleClassTransformation(List<BytecodeTransformerBuildItem> bytecodeTransformerBuildItems, ApplicationArchivesBuildItem appArchives) throws ExecutionException, InterruptedException {
        if (bytecodeTransformerBuildItems.isEmpty()) {
            return new TransformedClassesBuildItem(Collections.emptyMap());
        }
        HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
        for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
            bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i.getVisitorFunction());
        }
        ConcurrentHashMap transformedToArchive = new ConcurrentHashMap();
        ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ConcurrentLinkedDeque transformed = new ConcurrentLinkedDeque();
        try {
            final ClassLoader transformCl = Thread.currentThread().getContextClassLoader();
            for (Map.Entry entry : bytecodeTransformers.entrySet()) {
                final String className = (String)entry.getKey();
                ApplicationArchive archive = appArchives.containingArchive((String)entry.getKey());
                if (archive != null) {
                    final List visitors = (List)entry.getValue();
                    final String classFileName = className.replace(".", "/") + ".class";
                    archive.processEntry(classFileName, (classFile, jar) -> {
                        transformedToArchive.put(classFileName, jar);
                        transformed.add(executorPool.submit(new Callable<TransformedClassesBuildItem.TransformedClass>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public TransformedClassesBuildItem.TransformedClass call() throws Exception {
                                ClassLoader old = Thread.currentThread().getContextClassLoader();
                                try {
                                    QuarkusClassWriter writer;
                                    Thread.currentThread().setContextClassLoader(transformCl);
                                    if (Files.size(classFile) > Integer.MAX_VALUE) {
                                        throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
                                    }
                                    ClassReader cr = new ClassReader(Files.readAllBytes(classFile));
                                    QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
                                    for (BiFunction i : visitors) {
                                        visitor = (ClassVisitor)i.apply(className, visitor);
                                    }
                                    cr.accept((ClassVisitor)visitor, 0);
                                    TransformedClassesBuildItem.TransformedClass transformedClass = new TransformedClassesBuildItem.TransformedClass(writer.toByteArray(), classFileName);
                                    return transformedClass;
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(old);
                                }
                            }
                        }));
                    });
                    continue;
                }
                log.warnf("Cannot transform %s as it's containing application archive could not be found.", entry.getKey());
            }
        }
        finally {
            executorPool.shutdown();
        }
        HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>> transformedClassesByJar = new HashMap<Path, Set<TransformedClassesBuildItem.TransformedClass>>();
        if (!transformed.isEmpty()) {
            for (Future i : transformed) {
                TransformedClassesBuildItem.TransformedClass res = (TransformedClassesBuildItem.TransformedClass)i.get();
                transformedClassesByJar.computeIfAbsent((Path)transformedToArchive.get(res.getFileName()), (Function<Path, Set<TransformedClassesBuildItem.TransformedClass>>)((Function<Path, Set>)a -> new HashSet())).add(res);
            }
        }
        return new TransformedClassesBuildItem(transformedClassesByJar);
    }
}

