/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.index.ArtifactIndex;
import io.quarkus.deployment.index.ClassPathArtifactResolver;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);
    private static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final int REQUIRED_INDEX_VERSION = 8;
    IndexDependencyConfiguration config;

    @BuildStep
    void addConfiguredIndexedDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        for (IndexDependencyConfig indexDependencyConfig : this.config.indexDependency.values()) {
            indexDependencyBuildItemBuildProducer.produce(new IndexDependencyBuildItem(indexDependencyConfig.groupId, indexDependencyConfig.artifactId, indexDependencyConfig.classifier.orElse(null)));
        }
    }

    @BuildStep
    ApplicationArchivesBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables, ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItem, List<IndexDependencyBuildItem> indexDependencyBuildItems, LiveReloadBuildItem liveReloadContext, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        for (AdditionalApplicationArchiveMarkerBuildItem i : appMarkers) {
            markerFiles.add(i.getFile());
        }
        IndexCache indexCache = liveReloadContext.getContextObject(IndexCache.class);
        if (indexCache == null) {
            indexCache = new IndexCache();
            liveReloadContext.setContextObject(IndexCache.class, indexCache);
        }
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(buildCloseables, Thread.currentThread().getContextClassLoader(), markerFiles, root, additionalApplicationArchiveBuildItem, indexDependencyBuildItems, indexCache, curateOutcomeBuildItem);
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), root.getRootDirs(), root.getPaths()), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, List<IndexDependencyBuildItem> indexDependencyBuildItem, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException {
        ArrayList<ApplicationArchive> appArchives = new ArrayList<ApplicationArchive>();
        HashSet<Path> indexedPaths = new HashSet<Path>();
        HashSet<String> markers = new HashSet<String>(applicationArchiveFiles);
        markers.add(JANDEX_INDEX);
        ApplicationArchiveBuildStep.addMarkerFilePaths(markers, root, curateOutcomeBuildItem, indexedPaths, appArchives, buildCloseables, classLoader, indexCache);
        this.addIndexDependencyPaths(indexDependencyBuildItem, classLoader, root, indexedPaths, appArchives, buildCloseables, indexCache);
        for (AdditionalApplicationArchiveBuildItem i : additionalApplicationArchives) {
            for (Path apPath : i.getPaths()) {
                if (root.getPaths().contains(apPath) || !indexedPaths.add(apPath)) continue;
                appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, apPath));
            }
        }
        return appArchives;
    }

    public void addIndexDependencyPaths(List<IndexDependencyBuildItem> indexDependencyBuildItems, ClassLoader classLoader, ArchiveRootBuildItem root, Set<Path> indexedDeps, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, IndexCache indexCache) {
        if (indexDependencyBuildItems.isEmpty()) {
            return;
        }
        ArtifactIndex artifactIndex = new ArtifactIndex(new ClassPathArtifactResolver(classLoader));
        try {
            for (IndexDependencyBuildItem indexDependencyBuildItem : indexDependencyBuildItems) {
                String classifier = indexDependencyBuildItem.getClassifier();
                Path path = artifactIndex.getPath(indexDependencyBuildItem.getGroupId(), indexDependencyBuildItem.getArtifactId(), classifier == null || classifier.isEmpty() ? null : classifier);
                if (root.isExcludedFromIndexing(path) || root.getPaths().contains(path) || !indexedDeps.add(path)) continue;
                appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, path));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationArchive createApplicationArchive(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache, Path dep) throws IOException {
        FileSystem fs = Files.isDirectory(dep, new LinkOption[0]) ? null : buildCloseables.add(FileSystems.newFileSystem(dep, classLoader));
        return new ApplicationArchiveImpl(ApplicationArchiveBuildStep.indexPath(indexCache, dep), fs == null ? dep : fs.getRootDirectories().iterator().next(), fs, fs != null, dep);
    }

    private static IndexView indexPath(IndexCache indexCache, Path dep) throws IOException {
        LOGGER.debugf("Indexing dependency: %s", (Object)dep);
        return Files.isDirectory(dep, new LinkOption[0]) ? ApplicationArchiveBuildStep.handleFilePath(dep) : ApplicationArchiveBuildStep.handleJarPath(dep, indexCache);
    }

    private static void addMarkerFilePaths(Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, CurateOutcomeBuildItem curateOutcomeBuildItem, Set<Path> indexedPaths, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache) throws IOException {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getUserDependencies()) {
            PathsCollection artifactPaths = dep.getArtifact().getPaths();
            boolean containsMarker = false;
            for (Path p : artifactPaths) {
                if (root.isExcludedFromIndexing(p)) continue;
                if (Files.isDirectory(p, new LinkOption[0])) {
                    containsMarker = ApplicationArchiveBuildStep.containsMarker(p, applicationArchiveFiles);
                    if (!containsMarker) continue;
                    break;
                }
                try {
                    FileSystem fs = FileSystems.newFileSystem(p, classLoader);
                    Throwable throwable = null;
                    try {
                        containsMarker = ApplicationArchiveBuildStep.containsMarker(fs.getPath("/", new String[0]), applicationArchiveFiles);
                        if (!containsMarker) continue;
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fs.close();
                    }
                }
                catch (ProviderNotFoundException providerNotFoundException) {}
            }
            if (!containsMarker) continue;
            PathsCollection.Builder rootDirs = PathsCollection.builder();
            ArrayList<IndexView> indexes = new ArrayList<IndexView>(artifactPaths.size());
            for (Path p : artifactPaths) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    rootDirs.add(p);
                } else {
                    FileSystem fs = buildCloseables.add(FileSystems.newFileSystem(p, classLoader));
                    fs.getRootDirectories().forEach(arg_0 -> ((PathsCollection.Builder)rootDirs).add(arg_0));
                }
                indexes.add(ApplicationArchiveBuildStep.indexPath(indexCache, p));
                indexedPaths.add(p);
            }
            appArchives.add(new ApplicationArchiveImpl((IndexView)(indexes.size() == 1 ? (IndexView)indexes.get(0) : CompositeIndex.create(indexes)), rootDirs.build(), artifactPaths));
        }
    }

    private static boolean containsMarker(Path dir, Set<String> applicationArchiveFiles) throws IOException {
        for (String file : applicationArchiveFiles) {
            if (!Files.exists(dir.resolve(file), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static Index handleFilePath(Path path) throws IOException {
        Path existing = path.resolve(JANDEX_INDEX);
        if (Files.exists(existing, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(existing.toFile());){
                IndexReader reader = new IndexReader((InputStream)in);
                if (reader.getIndexVersion() < 8) {
                    LOGGER.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)path);
                    Index index = ApplicationArchiveBuildStep.indexFilePath(path);
                    return index;
                }
                Index index = reader.read();
                return index;
            }
        }
        return ApplicationArchiveBuildStep.indexFilePath(path);
    }

    private static Index indexFilePath(Path path) throws IOException {
        Indexer indexer = new Indexer();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.forEach(path1 -> {
                if (path1.toString().endsWith(".class")) {
                    try (FileInputStream in = new FileInputStream(path1.toFile());){
                        indexer.index((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return indexer.complete();
    }

    private static Index handleJarPath(Path path, IndexCache indexCache) throws IOException {
        return indexCache.cache.computeIfAbsent(path, new Function<Path, Index>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Index apply(Path path) {
                try (JarFile file = new JarFile(path.toFile());){
                    ZipEntry existing = file.getEntry(ApplicationArchiveBuildStep.JANDEX_INDEX);
                    if (existing != null) {
                        try (InputStream in = file.getInputStream(existing);){
                            IndexReader reader = new IndexReader(in);
                            if (reader.getIndexVersion() < 8) {
                                LOGGER.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)path);
                                Index index = ApplicationArchiveBuildStep.indexJar(file);
                                return index;
                            }
                            Index index = reader.read();
                            return index;
                        }
                    }
                    Index index = ApplicationArchiveBuildStep.indexJar(file);
                    return index;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to process " + path, e);
                }
            }
        });
    }

    private static Index indexJar(JarFile file) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream inputStream = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                indexer.index(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    private static final class IndexCache {
        final Map<Path, Index> cache = new HashMap<Path, Index>();

        private IndexCache() {
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class IndexDependencyConfiguration {
        @ConfigItem(name="<<parent>>")
        Map<String, IndexDependencyConfig> indexDependency;

        IndexDependencyConfiguration() {
        }
    }
}

