/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;

public class DevModeMain
implements Closeable {
    public static final String DEV_MODE_CONTEXT = "META-INF/dev-mode-context.dat";
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private final DevModeContext context;
    private static volatile CuratedApplication curatedApplication;
    private Closeable realCloseable;

    public DevModeMain(DevModeContext context) {
        this.context = context;
    }

    public static void main(String ... args) throws Exception {
        try (InputStream devModeCp = DevModeMain.class.getClassLoader().getResourceAsStream(DEV_MODE_CONTEXT);){
            DevModeContext context;
            try {
                context = (DevModeContext)new ObjectInputStream(new DataInputStream(devModeCp)).readObject();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to deserialize the dev mode context. Does the Quarkus plugin version match the version of Quarkus that is in use?", e);
            }
            context.setArgs(args);
            DevModeMain devModeMain = new DevModeMain(context);
            devModeMain.start();
        }
    }

    public void start() throws Exception {
        for (Map.Entry<String, String> i : this.context.getSystemProperties().entrySet()) {
            if (System.getProperties().containsKey(i.getKey())) continue;
            System.setProperty(i.getKey(), i.getValue());
        }
        try {
            Path path;
            URL thisArchive = this.getClass().getResource(DevModeMain.class.getSimpleName() + ".class");
            int endIndex = thisArchive.getPath().indexOf("!");
            if (endIndex != -1) {
                path = Paths.get(new URI(thisArchive.getPath().substring(0, endIndex)));
            } else {
                path = Paths.get(thisArchive.toURI());
                path = path.getParent();
                for (char i : DevModeMain.class.getName().toCharArray()) {
                    if (i != '.') continue;
                    path = path.getParent();
                }
            }
            PathsCollection.Builder appRoots = PathsCollection.builder();
            Path p = Paths.get(this.context.getApplicationRoot().getClassesPath(), new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                appRoots.add(p);
            }
            if (this.context.getApplicationRoot().getResourcesOutputPath() != null && !this.context.getApplicationRoot().getResourcesOutputPath().equals(this.context.getApplicationRoot().getClassesPath()) && Files.exists(p = Paths.get(this.context.getApplicationRoot().getResourcesOutputPath(), new String[0]), new LinkOption[0])) {
                appRoots.add(p);
            }
            QuarkusBootstrap.Builder bootstrapBuilder = QuarkusBootstrap.builder().setApplicationRoot(appRoots.build()).setIsolateDeployment(true).setLocalProjectDiscovery(this.context.isLocalProjectDiscovery()).addAdditionalDeploymentArchive(path).setMode(QuarkusBootstrap.Mode.DEV);
            if (this.context.getProjectDir() != null) {
                bootstrapBuilder.setProjectRoot(this.context.getProjectDir().toPath());
            } else {
                bootstrapBuilder.setProjectRoot(new File(".").toPath());
            }
            for (DevModeContext.ModuleInfo i : this.context.getAllModules()) {
                if (i.getClassesPath() != null) {
                    Path classesPath = Paths.get(i.getClassesPath(), new String[0]);
                    bootstrapBuilder.addAdditionalApplicationArchive(new AdditionalDependency(classesPath, true, false));
                }
                if (i.getResourcesOutputPath() == null || i.getResourcesOutputPath().equals(i.getClassesPath())) continue;
                Path resourceOutputPath = Paths.get(i.getResourcesOutputPath(), new String[0]);
                bootstrapBuilder.addAdditionalApplicationArchive(new AdditionalDependency(resourceOutputPath, true, false));
            }
            this.copyDotEnvFile();
            Properties buildSystemProperties = new Properties();
            buildSystemProperties.putAll(this.context.getBuildSystemProperties());
            bootstrapBuilder.setBuildSystemProperties(buildSystemProperties);
            curatedApplication = bootstrapBuilder.setTest(this.context.isTest()).build().bootstrap();
            this.realCloseable = (Closeable)curatedApplication.runInAugmentClassLoader(IsolatedDevModeMain.class.getName(), Collections.singletonMap(DevModeContext.class.getName(), this.context));
        }
        catch (Throwable t) {
            log.error((Object)"Quarkus dev mode failed to start in curation phase", t);
            throw new RuntimeException(t);
        }
    }

    private void copyDotEnvFile() {
        File projectDir = this.context.getProjectDir();
        if (projectDir == null) {
            return;
        }
        Path currentDir = Paths.get("", new String[0]).toAbsolutePath().normalize();
        if (projectDir.toPath().equals(currentDir)) {
            return;
        }
        Path dotEnvPath = projectDir.toPath().resolve(".env");
        if (Files.exists(dotEnvPath, new LinkOption[0])) {
            try {
                Path link = currentDir.resolve(".env");
                this.silentDeleteFile(link);
                Files.createSymbolicLink(link, dotEnvPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn((Object)"Unable to copy .env file", (Throwable)e);
            }
        }
    }

    private void silentDeleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.realCloseable != null) {
            this.realCloseable.close();
        }
        if (ApplicationStateNotification.getState() == ApplicationStateNotification.State.STARTED) {
            ApplicationStateNotification.waitForApplicationStop();
        }
    }
}

