/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class IDEDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>> {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> stringObjectMap) {
        Path appClasses = (Path)stringObjectMap.get("app-classes");
        DevModeContext devModeContext = new DevModeContext();
        devModeContext.setArgs((String[])stringObjectMap.get("args"));
        try {
            if (BuildToolHelper.isMavenProject((Path)appClasses)) {
                LocalProject project = LocalProject.loadWorkspace((Path)appClasses);
                DevModeContext.ModuleInfo root = this.toModule(project);
                devModeContext.setApplicationRoot(root);
                for (Map.Entry module : project.getWorkspace().getProjects().entrySet()) {
                    if (((AppArtifactKey)module.getKey()).equals((Object)project.getKey())) continue;
                    devModeContext.getAdditionalModules().add(this.toModule((LocalProject)module.getValue()));
                }
            } else {
                QuarkusModel model = QuarkusModelHelper.deserializeQuarkusModel((Path)((Path)stringObjectMap.get("quarkus-internal.serialized-quarkus-model.path")));
                WorkspaceModule launchingModule = model.getWorkspace().getMainModule();
                DevModeContext.ModuleInfo root = this.toModule(launchingModule);
                devModeContext.setApplicationRoot(root);
                for (WorkspaceModule additionalModule : model.getWorkspace().getAllModules()) {
                    if (additionalModule.getArtifactCoords().equals(launchingModule.getArtifactCoords())) continue;
                    devModeContext.getAdditionalModules().add(this.toModule(additionalModule));
                }
            }
        }
        catch (AppModelResolverException e) {
            log.error((Object)"Failed to load workspace, hot reload will not be available", (Throwable)e);
        }
        new IsolatedDevModeMain().accept(curatedApplication, Collections.singletonMap(DevModeContext.class.getName(), devModeContext));
    }

    private DevModeContext.ModuleInfo toModule(WorkspaceModule module) throws BootstrapGradleException {
        AppArtifactKey key = new AppArtifactKey(module.getArtifactCoords().getGroupId(), module.getArtifactCoords().getArtifactId(), module.getArtifactCoords().getClassifier());
        HashSet<String> sourceDirectories = new HashSet<String>();
        HashSet<String> sourceParents = new HashSet<String>();
        for (File srcDir : module.getSourceSourceSet().getSourceDirectories()) {
            sourceDirectories.add(srcDir.getPath());
            sourceParents.add(srcDir.getParent());
        }
        return new DevModeContext.ModuleInfo(key, module.getArtifactCoords().getArtifactId(), module.getProjectRoot().getPath(), sourceDirectories, QuarkusModelHelper.getClassPath((WorkspaceModule)module).toAbsolutePath().toString(), module.getSourceSourceSet().getResourceDirectory().toString(), module.getSourceSet().getResourceDirectory().getPath(), sourceParents, module.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString(), module.getBuildDir().toString());
    }

    private DevModeContext.ModuleInfo toModule(LocalProject project) {
        return new DevModeContext.ModuleInfo(project.getKey(), project.getArtifactId(), project.getDir().toAbsolutePath().toString(), Collections.singleton(project.getSourcesSourcesDir().toAbsolutePath().toString()), project.getClassesDir().toAbsolutePath().toString(), project.getResourcesSourcesDir().toAbsolutePath().toString(), project.getSourcesDir().toString(), project.getCodeGenOutputDir().toString(), project.getOutputDir().toString());
    }
}

