/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jbang;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.BuildStepBuilder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IDEDevModeMain;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class JBangAugmentorImpl
implements BiConsumer<CuratedApplication, Map<String, Object>> {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> resultMap) {
        QuarkusClassLoader classLoader = curatedApplication.getAugmentClassLoader();
        QuarkusBootstrap quarkusBootstrap = curatedApplication.getQuarkusBootstrap();
        QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder().setRoot(quarkusBootstrap.getApplicationRoot()).setClassLoader((ClassLoader)classLoader).addFinal(ApplicationClassNameBuildItem.class).setTargetDir(quarkusBootstrap.getTargetDirectory()).setDeploymentClassLoader((ClassLoader)curatedApplication.createDeploymentClassLoader()).setBuildSystemProperties(quarkusBootstrap.getBuildSystemProperties()).setEffectiveModel(curatedApplication.getAppModel());
        if (quarkusBootstrap.getBaseName() != null) {
            builder.setBaseName(quarkusBootstrap.getBaseName());
        }
        builder.setLaunchMode(LaunchMode.NORMAL);
        builder.setRebuild(quarkusBootstrap.isRebuild());
        builder.setLiveReloadState(new LiveReloadBuildItem(false, Collections.emptySet(), new HashMap()));
        for (AdditionalDependency i : quarkusBootstrap.getAdditionalApplicationArchives()) {
            if (!i.isForceApplicationArchive()) continue;
            builder.addAdditionalApplicationArchive(i.getArchivePath());
        }
        builder.addBuildChainCustomizer(new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder builder) {
                BuildStepBuilder stepBuilder = builder.addBuildStep(ctx -> ctx.produce((BuildItem)new ProcessInheritIODisabled()));
                stepBuilder.produces(ProcessInheritIODisabled.class).build();
            }
        });
        builder.excludeFromIndexing(quarkusBootstrap.getExcludeFromClassPath());
        builder.addFinal(GeneratedClassBuildItem.class);
        builder.addFinal(GeneratedResourceBuildItem.class);
        builder.addFinal(TransformedClassesBuildItem.class);
        boolean nativeRequested = "native".equals(System.getProperty("quarkus.package.type"));
        boolean containerBuildRequested = Boolean.getBoolean("quarkus.container-image.build");
        if (nativeRequested) {
            builder.addFinal(NativeImageBuildItem.class);
        }
        if (containerBuildRequested) {
            builder.addFinal(ArtifactResultBuildItem.class);
        }
        try {
            BuildResult buildResult = builder.build().run();
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            for (GeneratedClassBuildItem generatedClassBuildItem : buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
                result.put(generatedClassBuildItem.getName().replace(".", "/") + ".class", generatedClassBuildItem.getClassData());
            }
            for (GeneratedResourceBuildItem generatedResourceBuildItem : buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                result.put(generatedResourceBuildItem.getName(), generatedResourceBuildItem.getClassData());
            }
            for (Map.Entry entry : ((TransformedClassesBuildItem)buildResult.consume(TransformedClassesBuildItem.class)).getTransformedClassesByJar().entrySet()) {
                for (TransformedClassesBuildItem.TransformedClass transformed : (Set)entry.getValue()) {
                    result.put(transformed.getFileName(), transformed.getData());
                }
            }
            resultMap.put("files", result);
            ArrayList<String> javaargs = new ArrayList<String>();
            javaargs.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            resultMap.put("java-args", javaargs);
            if (nativeRequested) {
                resultMap.put("native-image", ((NativeImageBuildItem)buildResult.consume(NativeImageBuildItem.class)).getPath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DevModeContext.ModuleInfo toModule(WorkspaceModule module) throws BootstrapGradleException {
        AppArtifactKey key = new AppArtifactKey(module.getArtifactCoords().getGroupId(), module.getArtifactCoords().getArtifactId(), module.getArtifactCoords().getClassifier());
        HashSet<String> sourceDirectories = new HashSet<String>();
        HashSet<String> sourceParents = new HashSet<String>();
        for (File srcDir : module.getSourceSourceSet().getSourceDirectories()) {
            sourceDirectories.add(srcDir.getPath());
            sourceParents.add(srcDir.getParent());
        }
        return new DevModeContext.ModuleInfo(key, module.getArtifactCoords().getArtifactId(), module.getProjectRoot().getPath(), sourceDirectories, QuarkusModelHelper.getClassPath((WorkspaceModule)module).toAbsolutePath().toString(), module.getSourceSourceSet().getResourceDirectory().toString(), module.getSourceSet().getResourceDirectory().getPath(), sourceParents, module.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString(), module.getBuildDir().toString());
    }

    private DevModeContext.ModuleInfo toModule(LocalProject project) {
        return new DevModeContext.ModuleInfo(project.getKey(), project.getArtifactId(), project.getDir().toAbsolutePath().toString(), Collections.singleton(project.getSourcesSourcesDir().toAbsolutePath().toString()), project.getClassesDir().toAbsolutePath().toString(), project.getResourcesSourcesDir().toAbsolutePath().toString(), project.getSourcesDir().toString(), project.getCodeGenOutputDir().toString(), project.getOutputDir().toString());
    }
}

