/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.mutability;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PersistentAppModel;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.spi.DevModeType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DevModeTask {
    public static Closeable main(Path appRoot) throws Exception {
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(appRoot.resolve("lib").resolve("deployment").resolve("appmodel.dat"), new OpenOption[0]));){
            Properties buildSystemProperties = new Properties();
            try (InputStream buildIn = Files.newInputStream(appRoot.resolve("lib").resolve("deployment").resolve("build-system.properties"), new OpenOption[0]);){
                buildSystemProperties.load(buildIn);
            }
            PersistentAppModel appModel = (PersistentAppModel)in.readObject();
            AppModel existingModel = appModel.getAppModel(appRoot);
            DevModeContext context = DevModeTask.createDevModeContext(appRoot, existingModel);
            CuratedApplication bootstrap = QuarkusBootstrap.builder().setAppArtifact(existingModel.getAppArtifact()).setExistingModel(existingModel).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setBuildSystemProperties(buildSystemProperties).setBaseName(appModel.getBaseName()).setApplicationRoot(existingModel.getAppArtifact().getPath()).setTargetDirectory(appRoot.getParent()).setBaseClassLoader(DevModeTask.class.getClassLoader()).build().bootstrap();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(DevModeContext.class.getName(), context);
            map.put("app-root", appRoot);
            map.put(DevModeType.class.getName(), DevModeType.REMOTE_SERVER_SIDE);
            Closeable closeable = (Closeable)bootstrap.runInAugmentClassLoader(IsolatedDevModeMain.class.getName(), map);
            return closeable;
        }
    }

    private static DevModeContext createDevModeContext(Path appRoot, AppModel appModel) throws IOException {
        final DevModeContext context = new DevModeContext();
        DevModeTask.extractDevModeClasses(appRoot, appModel, new PostExtractAction(){

            @Override
            public void run(AppArtifact dep, Path moduleClasses, boolean appArtifact) {
                dep.setPath(moduleClasses);
                DevModeContext.ModuleInfo module = new DevModeContext.ModuleInfo(dep.getKey(), dep.getArtifactId(), null, Collections.emptySet(), moduleClasses.toAbsolutePath().toString(), null, moduleClasses.toAbsolutePath().toString(), null, null, null);
                if (appArtifact) {
                    context.setApplicationRoot(module);
                } else {
                    context.getAdditionalModules().add(module);
                }
            }
        });
        context.setAbortOnFailedStart(false);
        context.setLocalProjectDiscovery(false);
        return context;
    }

    public static void extractDevModeClasses(Path appRoot, AppModel appModel, PostExtractAction postExtractAction) throws IOException {
        Path extracted = appRoot.resolve("dev");
        Files.createDirectories(extracted, new FileAttribute[0]);
        HashMap<AppArtifactKey, AppArtifact> userDependencies = new HashMap<AppArtifactKey, AppArtifact>();
        for (AppDependency i : appModel.getUserDependencies()) {
            userDependencies.put(i.getArtifact().getKey(), i.getArtifact());
        }
        for (AppDependency i : appModel.getLocalProjectArtifacts()) {
            boolean appArtifact = i.equals((Object)appModel.getAppArtifact().getKey());
            AppArtifact dep = (AppArtifact)userDependencies.get(i);
            Path moduleClasses = null;
            if (dep == null) {
                if (appArtifact) {
                    dep = appModel.getAppArtifact();
                    moduleClasses = extracted.resolve("app");
                }
            } else {
                moduleClasses = extracted.resolve(i.getGroupId()).resolve(i.getArtifactId());
            }
            if (dep == null) continue;
            IoUtils.recursiveDeleteAndThenCreate(moduleClasses);
            for (final Path p : dep.getPaths()) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    final Path moduleTarget = moduleClasses;
                    Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            Files.createDirectories(moduleTarget.resolve(p.relativize(dir)), new FileAttribute[0]);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Path target = moduleTarget.resolve(p.relativize(file));
                            Files.copy(file, target, new CopyOption[0]);
                            Files.setLastModifiedTime(target, Files.getLastModifiedTime(file, new LinkOption[0]));
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            throw exc;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                ZipInputStream fs = new ZipInputStream(Files.newInputStream(p, new OpenOption[0]));
                Throwable throwable = null;
                try {
                    ZipEntry entry = fs.getNextEntry();
                    while (entry != null) {
                        Path target = moduleClasses.resolve(entry.getName());
                        if (entry.getName().endsWith("/")) {
                            Files.createDirectories(target, new FileAttribute[0]);
                        } else if (!Files.exists(target, new LinkOption[0])) {
                            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                                IoUtils.copy((OutputStream)out, (InputStream)fs);
                            }
                        }
                        entry = fs.getNextEntry();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fs == null) continue;
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fs.close();
                }
            }
            if (postExtractAction == null) continue;
            postExtractAction.run(dep, moduleClasses, appArtifact);
        }
    }

    static interface PostExtractAction {
        public void run(AppArtifact var1, Path var2, boolean var3);
    }
}

