/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.util.ExecUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class IsDockerWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger((String)IsDockerWorking.class.getName());
    private final boolean silent;

    public IsDockerWorking() {
        this(false);
    }

    public IsDockerWorking(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean getAsBoolean() {
        try {
            if (!ExecUtil.execSilent("docker", "-v")) {
                LOGGER.warn((Object)"'docker -v' returned an error code. Make sure your Docker binary is correct");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warnf("No Docker binary found or general error: %s", (Object)e);
            return false;
        }
        try {
            OutputFilter filter = new OutputFilter();
            if (ExecUtil.exec(new File("."), filter, "docker", "version", "--format", "'{{.Server.Version}}'")) {
                LOGGER.info((Object)("Docker daemon found. Version:" + filter.getOutput()));
                return true;
            }
            if (!this.silent) {
                LOGGER.warn((Object)"Could not determine version of Docker daemon");
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unexpected error occurred while determining Docker daemon version", (Throwable)e);
            return false;
        }
    }

    public static class OutputFilter
    implements Function<InputStream, Runnable> {
        private final StringBuilder builder = new StringBuilder();

        @Override
        public Runnable apply(InputStream is) {
            return () -> {
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        this.builder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading stream.", e);
                }
            };
        }

        public String getOutput() {
            return this.builder.toString();
        }
    }
}

