/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.spi.DevModeType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class DevModeMain
implements Closeable {
    public static final String DEV_MODE_CONTEXT = "META-INF/dev-mode-context.dat";
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private final DevModeContext context;
    private static volatile CuratedApplication curatedApplication;
    private Closeable realCloseable;

    public DevModeMain(DevModeContext context) {
        this.context = context;
    }

    public static void main(String ... args) throws Exception {
        try (InputStream devModeCp = DevModeMain.class.getClassLoader().getResourceAsStream(DEV_MODE_CONTEXT);){
            DevModeContext context;
            try {
                context = (DevModeContext)new ObjectInputStream(new DataInputStream(devModeCp)).readObject();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to deserialize the dev mode context. Does the Quarkus plugin version match the version of Quarkus that is in use?", e);
            }
            context.setArgs(args);
            DevModeMain devModeMain = new DevModeMain(context);
            devModeMain.start();
        }
    }

    public void start() throws Exception {
        for (Map.Entry<String, String> i : this.context.getSystemProperties().entrySet()) {
            if (System.getProperties().containsKey(i.getKey())) continue;
            System.setProperty(i.getKey(), i.getValue());
        }
        try {
            Path path;
            URL thisArchive = this.getClass().getResource(DevModeMain.class.getSimpleName() + ".class");
            int endIndex = thisArchive.getPath().indexOf("!");
            if (endIndex != -1) {
                path = Paths.get(new URI(thisArchive.getPath().substring(0, endIndex)));
            } else {
                path = Paths.get(thisArchive.toURI());
                path = path.getParent();
                for (char i : DevModeMain.class.getName().toCharArray()) {
                    if (i != '.') continue;
                    path = path.getParent();
                }
            }
            PathsCollection.Builder appRoots = PathsCollection.builder();
            Path p = Paths.get(this.context.getApplicationRoot().getMain().getClassesPath(), new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                appRoots.add(p);
            }
            if (this.context.getApplicationRoot().getMain().getResourcesOutputPath() != null && !this.context.getApplicationRoot().getMain().getResourcesOutputPath().equals(this.context.getApplicationRoot().getMain().getClassesPath()) && Files.exists(p = Paths.get(this.context.getApplicationRoot().getMain().getResourcesOutputPath(), new String[0]), new LinkOption[0])) {
                appRoots.add(p);
            }
            QuarkusBootstrap.Builder bootstrapBuilder = QuarkusBootstrap.builder().setApplicationRoot(appRoots.build()).setIsolateDeployment(true).setLocalProjectDiscovery(this.context.isLocalProjectDiscovery()).addAdditionalDeploymentArchive(path).setBaseName(this.context.getBaseName()).setMode(this.context.getMode());
            if (this.context.getDevModeRunnerJarFile() != null) {
                bootstrapBuilder.setTargetDirectory(this.context.getDevModeRunnerJarFile().getParentFile().toPath());
            }
            if (this.context.getProjectDir() != null) {
                bootstrapBuilder.setProjectRoot(this.context.getProjectDir().toPath());
            } else {
                bootstrapBuilder.setProjectRoot(new File(".").toPath());
            }
            for (AppArtifactKey appArtifactKey : this.context.getLocalArtifacts()) {
                bootstrapBuilder.addLocalArtifact(appArtifactKey);
            }
            for (DevModeContext.ModuleInfo moduleInfo : this.context.getAdditionalModules()) {
                if (moduleInfo.getMain().getClassesPath() != null) {
                    Path classesPath = Paths.get(moduleInfo.getMain().getClassesPath(), new String[0]);
                    bootstrapBuilder.addAdditionalApplicationArchive(new AdditionalDependency(classesPath, true, false));
                }
                if (moduleInfo.getMain().getResourcesOutputPath() == null || moduleInfo.getMain().getResourcesOutputPath().equals(moduleInfo.getMain().getClassesPath())) continue;
                Path resourceOutputPath = Paths.get(moduleInfo.getMain().getResourcesOutputPath(), new String[0]);
                bootstrapBuilder.addAdditionalApplicationArchive(new AdditionalDependency(resourceOutputPath, true, false));
            }
            this.linkDotEnvFile();
            Properties buildSystemProperties = new Properties();
            buildSystemProperties.putAll(this.context.getBuildSystemProperties());
            bootstrapBuilder.setBuildSystemProperties(buildSystemProperties);
            HashMap<String, DevModeContext> hashMap = new HashMap<String, DevModeContext>();
            hashMap.put(DevModeContext.class.getName(), this.context);
            hashMap.put(DevModeType.class.getName(), (DevModeContext)DevModeType.LOCAL);
            curatedApplication = bootstrapBuilder.setTest(this.context.isTest()).build().bootstrap();
            this.realCloseable = (Closeable)curatedApplication.runInAugmentClassLoader(this.context.getAlternateEntryPoint() == null ? IsolatedDevModeMain.class.getName() : this.context.getAlternateEntryPoint(), hashMap);
        }
        catch (Throwable t) {
            log.error((Object)"Quarkus dev mode failed to start", t);
            throw new RuntimeException(t);
        }
    }

    private void linkDotEnvFile() {
        block8: {
            File projectDir = this.context.getProjectDir();
            if (projectDir == null) {
                return;
            }
            Path currentDir = Paths.get("", new String[0]).toAbsolutePath().normalize();
            if (projectDir.toPath().equals(currentDir)) {
                return;
            }
            Path dotEnvPath = projectDir.toPath().resolve(".env");
            if (Files.exists(dotEnvPath, new LinkOption[0])) {
                Path link = currentDir.resolve(".env");
                this.silentDeleteFile(link);
                try {
                    try {
                        Files.createSymbolicLink(link, dotEnvPath, new FileAttribute[0]);
                    }
                    catch (FileSystemException e) {
                        if (SystemUtils.IS_OS_WINDOWS) {
                            log.debug((Object)"Falling back to mklink on Windows after FileSystemException", (Throwable)e);
                            this.makeHardLinkWindowsFallback(link, dotEnvPath);
                            break block8;
                        }
                        throw e;
                    }
                }
                catch (IOException | InterruptedException e) {
                    log.warn((Object)"Unable to link .env file", (Throwable)e);
                }
            }
        }
    }

    private void silentDeleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeHardLinkWindowsFallback(Path link, Path dotEnvPath) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("cmd.exe", "/C", "mklink", "/H", link.toString(), dotEnvPath.toString()).redirectOutput(new File("NUL")).redirectError(ProcessBuilder.Redirect.PIPE).start();
        try {
            ByteArrayOutputStream errStream = new ByteArrayOutputStream();
            ProcessUtil.streamErrorTo(new PrintStream(errStream), process);
            int exitValue = process.waitFor();
            if (exitValue > 0) {
                throw new IOException("mklink /H execution failed with exit code " + exitValue + ": " + new String(errStream.toByteArray()));
            }
        }
        finally {
            process.destroy();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.realCloseable != null) {
            this.realCloseable.close();
        }
        if (ApplicationStateNotification.getState() == ApplicationStateNotification.State.STARTED) {
            ApplicationStateNotification.waitForApplicationStop();
        }
    }
}

