/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class TestConsoleHandler
implements TestListener {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    public static final String PAUSED_PROMPT = "\u001b[33mTests paused, press [r] to resume\u001b[0m";
    public static final String FIRST_RUN_PROMPT = "\u001b[33mRunning Tests for the first time\u001b[0m";
    public static final String RUNNING_PROMPT = "Press [r] to re-run, [v] to view full results, [p] to pause, [h] for more options>";
    public static final String ABORTED_PROMPT = "Test run aborted.";
    boolean firstRun = true;
    boolean disabled = true;
    volatile InputHandler.ConsoleStatus promptHandler;
    volatile TestController testController;
    private String lastStatus;
    private final InputHandler inputHandler = new InputHandler(){

        public void handleInput(int[] keys) {
            block10: {
                block9: {
                    if (!TestConsoleHandler.this.disabled) break block9;
                    for (int i : keys) {
                        if (i != 114) continue;
                        TestSupport.instance().get().start();
                    }
                    break block10;
                }
                if (TestConsoleHandler.this.firstRun) break block10;
                for (int k : keys) {
                    if (k == 114) {
                        TestConsoleHandler.this.testController.runAllTests();
                    }
                    if (k == 102) {
                        TestConsoleHandler.this.testController.runFailedTests();
                        continue;
                    }
                    if (k == 118) {
                        TestConsoleHandler.this.testController.printFullResults();
                        continue;
                    }
                    if (k == 105) {
                        TestConsoleHandler.this.testController.toggleInstrumentation();
                        continue;
                    }
                    if (k == 111) {
                        TestConsoleHandler.this.testController.toggleTestOutput();
                        continue;
                    }
                    if (k == 112) {
                        TestSupport.instance().get().stop();
                        continue;
                    }
                    if (k == 104) {
                        TestConsoleHandler.this.printUsage();
                        continue;
                    }
                    if (k != 98) continue;
                    TestConsoleHandler.this.testController.toggleBrokenOnlyMode();
                }
            }
        }

        public void promptHandler(InputHandler.ConsoleStatus promptHandler) {
            TestConsoleHandler.this.promptHandler = promptHandler;
        }
    };

    public void install() {
        QuarkusConsole.INSTANCE.pushInputHandler(this.inputHandler);
    }

    @Override
    public void listenerRegistered(TestController testController) {
        this.testController = testController;
        this.promptHandler.setStatus(PAUSED_PROMPT);
    }

    public void printUsage() {
        System.out.println("r - Re-run all tests");
        System.out.println("f - Re-run failed tests");
        System.out.println("b - Toggle 'broken only' mode, where only failing tests are run");
        System.out.println("v - Print failures from the last test run");
        System.out.println("o - Toggle test output");
        System.out.println("i - Toggle instrumentation based reload");
        System.out.println("d - Disable tests");
        System.out.println("h - Display this help");
    }

    @Override
    public void testsEnabled() {
        this.disabled = false;
        if (this.firstRun) {
            this.promptHandler.setStatus(null);
            this.promptHandler.setPrompt(FIRST_RUN_PROMPT);
        } else {
            this.promptHandler.setPrompt(RUNNING_PROMPT);
            this.promptHandler.setStatus(this.lastStatus);
        }
    }

    @Override
    public void testsDisabled() {
        this.disabled = true;
        this.promptHandler.setPrompt(PAUSED_PROMPT);
        this.promptHandler.setStatus(null);
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        final AtomicLong totalNoTests = new AtomicLong();
        final AtomicLong skipped = new AtomicLong();
        final AtomicLong methodCount = new AtomicLong();
        final AtomicLong failureCount = new AtomicLong();
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runStarted(long toRun) {
                totalNoTests.set(toRun);
                TestConsoleHandler.this.promptHandler.setStatus("Running 0/" + toRun + ".");
            }

            @Override
            public void testComplete(TestResult result) {
                if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failureCount.incrementAndGet();
                } else if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.incrementAndGet();
                }
                methodCount.incrementAndGet();
            }

            @Override
            public void runComplete(TestRunResults results) {
                TestConsoleHandler.this.firstRun = false;
                if (results.getCurrentFailing().isEmpty()) {
                    TestConsoleHandler.this.lastStatus = "\u001b[32mTests all passed, " + methodCount.get() + " tests were run, " + skipped.get() + " were skipped. Tests took " + results.getTotalTime() + "ms.\u001b[0m";
                } else {
                    int failedTestsNum = results.getCurrentFailing().size();
                    boolean hasFailingTests = failedTestsNum > 0;
                    for (Map.Entry<String, TestClassResult> classEntry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : classEntry.getValue().getFailing()) {
                            log.error((Object)("Test " + test.getDisplayName() + " failed \n"), (Throwable)test.getTestExecutionResult().getThrowable().get());
                        }
                    }
                    String output = String.format("Test run failed, %d tests were run, ", methodCount.get()) + String.format("%s%d failed%s, ", hasFailingTests ? "\u001b[1m" : "", failedTestsNum, hasFailingTests ? "\u001b[2m" : "") + String.format("%d were skipped. Tests took %dms", skipped.get(), results.getTotalTime());
                    TestConsoleHandler.this.lastStatus = "\u001b[91m" + output + "\u001b[0m";
                }
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.this.lastStatus);
            }

            @Override
            public void noTests() {
                TestConsoleHandler.this.firstRun = false;
                TestConsoleHandler.this.lastStatus = "No tests to run";
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.this.lastStatus);
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
            }

            @Override
            public void runAborted() {
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.ABORTED_PROMPT);
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
                TestConsoleHandler.this.firstRun = false;
            }

            @Override
            public void testStarted(TestIdentifier testIdentifier, String className) {
                TestConsoleHandler.this.promptHandler.setStatus("Running " + methodCount.get() + "/" + totalNoTests + (String)(failureCount.get() == 0L ? "." : ". " + failureCount + " failures so far.") + " Running: " + className + "#" + testIdentifier.getDisplayName());
            }
        });
    }
}

