/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class TestConsoleHandler
implements TestListener {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    public static final String PAUSED_PROMPT = "\u001b[33mTests paused, press [r] to resume\u001b[0m";
    public static final String FIRST_RUN_PROMPT = "\u001b[33mRunning Tests for the first time\u001b[0m";
    public static final String RUNNING_PROMPT = "Press [r] to re-run, [v] to view full results, [p] to pause, [h] for more options>";
    public static final String ABORTED_PROMPT = "Test run aborted.";
    boolean firstRun = true;
    boolean disabled = true;
    volatile InputHandler.ConsoleStatus promptHandler;
    volatile TestController testController;
    private String lastStatus;
    private final InputHandler inputHandler = new InputHandler(){

        public void handleInput(int[] keys) {
            block14: {
                block13: {
                    if (!TestConsoleHandler.this.disabled) break block13;
                    for (int i : keys) {
                        if (i != 114) continue;
                        TestConsoleHandler.this.promptHandler.setStatus("\u001b[33mStarting tests\u001b[0m");
                        TestSupport.instance().get().start();
                    }
                    break block14;
                }
                if (TestConsoleHandler.this.firstRun) break block14;
                for (int k : keys) {
                    if (k == 114) {
                        TestConsoleHandler.this.testController.runAllTests();
                        continue;
                    }
                    if (k == 102) {
                        TestConsoleHandler.this.testController.runFailedTests();
                        continue;
                    }
                    if (k == 118) {
                        TestConsoleHandler.this.testController.printFullResults();
                        continue;
                    }
                    if (k == 105) {
                        TestConsoleHandler.this.testController.toggleInstrumentation();
                        continue;
                    }
                    if (k == 111) {
                        TestConsoleHandler.this.testController.toggleTestOutput();
                        continue;
                    }
                    if (k == 112) {
                        TestSupport.instance().get().stop();
                        continue;
                    }
                    if (k == 104) {
                        TestConsoleHandler.this.printUsage();
                        continue;
                    }
                    if (k == 98) {
                        TestConsoleHandler.this.testController.toggleBrokenOnlyMode();
                        continue;
                    }
                    if (k == 108) {
                        RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
                        continue;
                    }
                    if (k != 115) continue;
                    try {
                        RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                    }
                    catch (IOException e) {
                        log.error((Object)"Live reload scan failed", (Throwable)e);
                    }
                }
            }
        }

        public void promptHandler(InputHandler.ConsoleStatus promptHandler) {
            TestConsoleHandler.this.promptHandler = promptHandler;
        }
    };

    public void install() {
        QuarkusConsole.INSTANCE.pushInputHandler(this.inputHandler);
        QuarkusClassLoader classLoader = (QuarkusClassLoader)this.getClass().getClassLoader();
        classLoader.addCloseTask(new Runnable(){

            @Override
            public void run() {
                QuarkusConsole.INSTANCE.popInputHandler();
            }
        });
    }

    @Override
    public void listenerRegistered(TestController testController) {
        this.testController = testController;
        this.promptHandler.setPrompt(PAUSED_PROMPT);
    }

    public void printUsage() {
        System.out.println("\nThe following commands are available:");
        System.out.println("[\u001b[32mr\u001b[0m] - Re-run all tests");
        System.out.println("[\u001b[32mf\u001b[0m] - Re-run failed tests");
        System.out.println("[\u001b[32mb\u001b[0m] - Toggle 'broken only' mode, where only failing tests are run (" + (this.testController.isBrokenOnlyMode() ? "\u001b[32menabled\u001b[0m" : "\u001b[91mdisabled\u001b[0m") + ")");
        System.out.println("[\u001b[32mv\u001b[0m] - Print failures from the last test run");
        System.out.println("[\u001b[32mo\u001b[0m] - Toggle test output (" + (this.testController.isDisplayTestOutput() ? "\u001b[32menabled\u001b[0m" : "\u001b[91mdisabled\u001b[0m") + ")");
        System.out.println("[\u001b[32mp\u001b[0m] - Pause tests");
        System.out.println("[\u001b[32mi\u001b[0m] - Toggle instrumentation based reload (" + (this.testController.isInstrumentationEnabled() ? "\u001b[32menabled\u001b[0m" : "\u001b[91mdisabled\u001b[0m") + ")");
        System.out.println("[\u001b[32ml\u001b[0m] - Toggle live reload (" + (this.testController.isLiveReloadEnabled() ? "\u001b[32menabled\u001b[0m" : "\u001b[91mdisabled\u001b[0m") + ")");
        System.out.println("[\u001b[32ms\u001b[0m] - Force live reload scan");
        System.out.println("[\u001b[32mh\u001b[0m] - Display this help");
    }

    @Override
    public void testsEnabled() {
        this.disabled = false;
        if (this.firstRun) {
            this.promptHandler.setStatus(null);
            this.promptHandler.setPrompt(FIRST_RUN_PROMPT);
        } else {
            this.promptHandler.setPrompt(RUNNING_PROMPT);
            this.promptHandler.setStatus(this.lastStatus);
        }
    }

    @Override
    public void testsDisabled() {
        this.disabled = true;
        this.promptHandler.setPrompt(PAUSED_PROMPT);
        this.promptHandler.setStatus(null);
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        final AtomicLong totalNoTests = new AtomicLong();
        final AtomicLong skipped = new AtomicLong();
        final AtomicLong methodCount = new AtomicLong();
        final AtomicLong failureCount = new AtomicLong();
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runStarted(long toRun) {
                totalNoTests.set(toRun);
                TestConsoleHandler.this.promptHandler.setStatus("Running 0/" + toRun + ".");
            }

            @Override
            public void testComplete(TestResult result) {
                if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failureCount.incrementAndGet();
                } else if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.incrementAndGet();
                }
                methodCount.incrementAndGet();
            }

            @Override
            public void runComplete(TestRunResults results) {
                TestConsoleHandler.this.firstRun = false;
                if (results.getCurrentTotalCount() == 0L) {
                    TestConsoleHandler.this.lastStatus = "\u001b[33mNo tests found\u001b[0m";
                } else if (results.getFailedCount() == 0L && results.getPassedCount() == 0L) {
                    TestConsoleHandler.this.lastStatus = String.format("\u001b[33mAll %d tests were skipped\u001b[0m", results.getSkippedCount());
                } else if (results.getCurrentFailing().isEmpty()) {
                    TestConsoleHandler.this.lastStatus = String.format("\u001b[32mAll %d tests are passing (%d skipped), %d tests were run in %dms.\u001b[0m", results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount(), results.getTotalTime());
                } else {
                    log.error((Object)("====================\u001b[91m TEST REPORT #" + results.getId() + "\u001b[0m ===================="));
                    for (Map.Entry<String, TestClassResult> classEntry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : classEntry.getValue().getFailing()) {
                            log.error((Object)("Test " + test.getDisplayName() + " failed \n"), (Throwable)test.getTestExecutionResult().getThrowable().get());
                        }
                    }
                    log.error((Object)(">>>>>>>>>>>>>>>>>>>>\u001b[91m " + results.getCurrentFailedCount() + " TESTS FAILED\u001b[0m <<<<<<<<<<<<<<<<<<<<"));
                    TestConsoleHandler.this.lastStatus = String.format("\u001b[91m%d tests failed (%d passing, %d skipped), %d tests were run in %dms.\u001b[0m", results.getCurrentFailedCount(), results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount(), results.getTotalTime());
                }
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.this.lastStatus);
            }

            @Override
            public void noTests(TestRunResults results) {
                TestConsoleHandler.this.firstRun = false;
                TestConsoleHandler.this.lastStatus = "No tests to run";
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.this.lastStatus);
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
            }

            @Override
            public void runAborted() {
                TestConsoleHandler.this.promptHandler.setStatus(TestConsoleHandler.ABORTED_PROMPT);
                TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
                TestConsoleHandler.this.firstRun = false;
            }

            @Override
            public void testStarted(TestIdentifier testIdentifier, String className) {
                TestConsoleHandler.this.promptHandler.setStatus("Running " + methodCount.get() + "/" + totalNoTests + (String)(failureCount.get() == 0L ? "." : ". " + failureCount + " failures so far.") + " Running: " + className + "#" + testIdentifier.getDisplayName());
            }
        });
    }
}

