/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.console.AeshConsole;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.spi.DevModeType;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class TestConsoleHandler
implements TestListener {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    public static final String PAUSED_PROMPT = "Tests paused, press [\u001b[34mr\u001b[0m] to resume, [\u001b[34mh\u001b[0m] for more options>\u001b[0m";
    public static final String FIRST_RUN_PROMPT = "\u001b[34mRunning Tests for the first time\u001b[0m";
    public static final String RUNNING_PROMPT = "Press [\u001b[34mr\u001b[0m] to re-run, [\u001b[34mv\u001b[0m] to view full results, [\u001b[34mp\u001b[0m] to pause, [\u001b[34mh\u001b[0m] for more options>";
    final DevModeType devModeType;
    boolean firstRun = true;
    boolean disabled = true;
    boolean currentlyFailing = false;
    volatile InputHandler.ConsoleStatus promptHandler;
    volatile TestController testController;
    private String lastResults;
    private final InputHandler inputHandler = new InputHandler(){

        public void handleInput(int[] keys) {
            for (int k : keys) {
                if (k == 104) {
                    TestConsoleHandler.this.printUsage();
                    continue;
                }
                if (k == 105 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    TestConsoleHandler.this.testController.toggleInstrumentation();
                    continue;
                }
                if (k == 108 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
                    continue;
                }
                if (k == 115 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    try {
                        RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                    }
                    catch (IOException e) {
                        log.error((Object)"Live reload scan failed", (Throwable)e);
                    }
                    continue;
                }
                if (k == 113) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            System.exit(0);
                        }
                    }, "Quarkus exit thread").run();
                    continue;
                }
                if (TestConsoleHandler.this.disabled) {
                    if (k != 114) continue;
                    TestConsoleHandler.this.promptHandler.setStatus("\u001b[34mStarting tests\u001b[0m");
                    TestSupport.instance().get().start();
                    continue;
                }
                if (TestConsoleHandler.this.firstRun) continue;
                if (k == 114) {
                    TestConsoleHandler.this.testController.runAllTests();
                    continue;
                }
                if (k == 102) {
                    TestConsoleHandler.this.testController.runFailedTests();
                    continue;
                }
                if (k == 118) {
                    TestConsoleHandler.this.testController.printFullResults();
                    continue;
                }
                if (k == 111 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    TestConsoleHandler.this.testController.toggleTestOutput();
                    continue;
                }
                if (k == 112) {
                    TestSupport.instance().get().stop();
                    continue;
                }
                if (k != 98) continue;
                TestConsoleHandler.this.testController.toggleBrokenOnlyMode();
            }
        }

        public void promptHandler(InputHandler.ConsoleStatus promptHandler) {
            TestConsoleHandler.this.promptHandler = promptHandler;
        }
    };

    public TestConsoleHandler(DevModeType devModeType) {
        this.devModeType = devModeType;
    }

    public void install() {
        QuarkusConsole.INSTANCE.pushInputHandler(this.inputHandler);
        QuarkusClassLoader classLoader = (QuarkusClassLoader)this.getClass().getClassLoader();
        classLoader.addCloseTask(new Runnable(){

            @Override
            public void run() {
                QuarkusConsole.INSTANCE.popInputHandler();
            }
        });
    }

    @Override
    public void listenerRegistered(TestController testController) {
        this.testController = testController;
        this.promptHandler.setPrompt(PAUSED_PROMPT);
    }

    public void printUsage() {
        System.out.println("\u001b[0m\nThe following commands are available:");
        if (this.disabled) {
            System.out.println(MessageFormat.helpOption("r", "Resume testing"));
        } else {
            System.out.println(MessageFormat.helpOption("r", "Re-run all tests"));
            System.out.println(MessageFormat.helpOption("f", "Re-run failed tests"));
            System.out.println(MessageFormat.helpOption("b", "Toggle 'broken only' mode, where only failing tests are run", this.testController.isBrokenOnlyMode()));
            System.out.println(MessageFormat.helpOption("v", "Print failures from the last test run"));
            if (this.devModeType != DevModeType.TEST_ONLY) {
                System.out.println(MessageFormat.helpOption("o", "Toggle test output", this.testController.isDisplayTestOutput()));
            }
            System.out.println(MessageFormat.helpOption("p", "Pause tests"));
        }
        if (this.devModeType != DevModeType.TEST_ONLY) {
            System.out.println(MessageFormat.helpOption("i", "Toggle instrumentation based reload", this.testController.isInstrumentationEnabled()));
            System.out.println(MessageFormat.helpOption("l", "Toggle live reload", this.testController.isLiveReloadEnabled()));
            System.out.println(MessageFormat.helpOption("s", "Force live reload scan"));
        }
        System.out.println(MessageFormat.helpOption("h", "Display this help"));
        System.out.println(MessageFormat.helpOption("q", "Quit"));
    }

    @Override
    public void testsEnabled() {
        this.disabled = false;
        if (this.firstRun) {
            this.promptHandler.setStatus(null);
            this.promptHandler.setResults(null);
            this.promptHandler.setPrompt(FIRST_RUN_PROMPT);
        } else {
            this.promptHandler.setPrompt(RUNNING_PROMPT);
            this.promptHandler.setResults(this.lastResults);
            this.promptHandler.setStatus(null);
        }
    }

    @Override
    public void testsDisabled() {
        this.disabled = true;
        this.promptHandler.setPrompt(PAUSED_PROMPT);
        this.promptHandler.setStatus(null);
        this.promptHandler.setResults(null);
    }

    @Override
    public void testCompileFailed(String message) {
        this.promptHandler.setCompileError(message);
    }

    @Override
    public void testCompileSucceeded() {
        this.promptHandler.setCompileError(null);
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        final AtomicLong totalNoTests = new AtomicLong();
        final AtomicLong skipped = new AtomicLong();
        final AtomicLong methodCount = new AtomicLong();
        final AtomicLong failureCount = new AtomicLong();
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runStarted(long toRun) {
                totalNoTests.set(toRun);
                TestConsoleHandler.this.promptHandler.setStatus("Running 0/" + toRun + ".");
            }

            @Override
            public void testComplete(TestResult result) {
                if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failureCount.incrementAndGet();
                } else if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.incrementAndGet();
                }
                methodCount.incrementAndGet();
            }

            @Override
            public void runComplete(TestRunResults results) {
                TestConsoleHandler.this.firstRun = false;
                SimpleDateFormat df = new SimpleDateFormat("kk:mm:ss");
                String end = " Tests completed at " + df.format(new Date());
                if (results.getTrigger() != null) {
                    ClassScanResult trigger = results.getTrigger();
                    LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
                    paths.addAll(trigger.getChangedClasses());
                    paths.addAll(trigger.getAddedClasses());
                    paths.addAll(trigger.getDeletedClasses());
                    end = paths.size() == 1 ? end + " due to changes to " + ((Path)paths.iterator().next()).getFileName() + "." : (paths.size() > 1 ? end + " due to changes to " + ((Path)paths.iterator().next()).getFileName() + " and " + (paths.size() - 1) + " other files." : end + ".");
                } else {
                    end = end + ".";
                }
                if (results.getTotalCount() == 0L) {
                    TestConsoleHandler.this.lastResults = "\u001b[34mNo tests found\u001b[0m";
                } else if (results.getFailedCount() == 0L && results.getPassedCount() == 0L) {
                    TestConsoleHandler.this.lastResults = String.format("\u001b[34mAll %d tests were skipped\u001b[0m", results.getSkippedCount());
                } else if (results.getCurrentFailing().isEmpty()) {
                    if (TestConsoleHandler.this.currentlyFailing) {
                        log.info((Object)"\u001b[32mAll tests are now passing\u001b[0m");
                    }
                    TestConsoleHandler.this.currentlyFailing = false;
                    TestConsoleHandler.this.lastResults = String.format("\u001b[32mAll %d tests are passing (%d skipped), %d tests were run in %dms." + end + "\u001b[0m", results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount() - results.getSkippedCount(), results.getTotalTime());
                } else {
                    TestConsoleHandler.this.currentlyFailing = true;
                    log.error((Object)MessageFormat.statusHeader("TEST REPORT #" + results.getId()));
                    for (Map.Entry<String, TestClassResult> classEntry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : classEntry.getValue().getFailing()) {
                            log.error((Object)("\u001b[91mTest " + test.getDisplayName() + " failed \n\u001b[0m"), (Throwable)test.getTestExecutionResult().getThrowable().get());
                        }
                    }
                    log.error((Object)MessageFormat.statusFooter("\u001b[91m" + results.getCurrentFailedCount() + " TESTS FAILED"));
                    TestConsoleHandler.this.lastResults = String.format("\u001b[91m%d tests failed\u001b[0m (\u001b[32m%d passing\u001b[0m, \u001b[34m%d skipped\u001b[0m)\u001b[91m, %d tests were run in %dms." + end + "\u001b[0m", results.getCurrentFailedCount(), results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount(), results.getTotalTime());
                }
                if (!TestConsoleHandler.this.disabled) {
                    TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.RUNNING_PROMPT);
                    TestConsoleHandler.this.promptHandler.setResults(TestConsoleHandler.this.lastResults);
                    TestConsoleHandler.this.promptHandler.setStatus(null);
                }
            }

            @Override
            public void noTests(TestRunResults results) {
                this.runComplete(results);
            }

            @Override
            public void runAborted() {
                TestConsoleHandler.this.firstRun = false;
            }

            @Override
            public void testStarted(TestIdentifier testIdentifier, String className) {
                String status = "Running " + methodCount.get() + "/" + totalNoTests + (String)(failureCount.get() == 0L ? "." : ". " + failureCount + " failures so far.") + " Running: " + className + "#" + testIdentifier.getDisplayName();
                if (TestSupport.instance().get().isDisplayTestOutput() && QuarkusConsole.INSTANCE instanceof AeshConsole) {
                    log.info((Object)status);
                }
                TestConsoleHandler.this.promptHandler.setStatus(status);
            }
        });
    }

    static class MessageFormat {
        public static final String RED = "\u001b[91m";
        public static final String GREEN = "\u001b[32m";
        public static final String BLUE = "\u001b[34m";
        public static final String RESET = "\u001b[0m";

        private MessageFormat() {
        }

        public static String statusHeader(String header) {
            return "\u001b[0m==================== " + header + "\u001b[0m ====================";
        }

        public static String statusFooter(String footer) {
            return "\u001b[0m>>>>>>>>>>>>>>>>>>>> " + footer + "\u001b[0m <<<<<<<<<<<<<<<<<<<<";
        }

        public static String toggleStatus(boolean enabled) {
            return " (" + (enabled ? "\u001b[32menabled\u001b[0m" : "\u001b[91mdisabled") + "\u001b[0m)";
        }

        public static String helpOption(String key, String description) {
            return "[\u001b[34m" + key + "\u001b[0m] - " + description;
        }

        public static String helpOption(String key, String description, boolean enabled) {
            return MessageFormat.helpOption(key, description) + MessageFormat.toggleStatus(enabled);
        }
    }
}

